/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.interpreter;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.storydriven.storydiagrams.diagram.custom.util.TypeUtil;
import org.storydriven.storydiagrams.diagram.interpreter.dialogs.SelectEClassifierBindingDialog;

public class ParameterBindingEditingSupport
extends EditingSupport {
    private final Map<EParameter, Object> bindings;
    private CheckboxCellEditor booleanCellEditor;
    private TextCellEditor byteCellEditor;
    private TextCellEditor charTextCellEditor;
    private SelectEClassifierBindingDialog dialog;
    private DialogCellEditor dialogCellEditor;
    private TextCellEditor doubleCellEditor;
    private ComboBoxCellEditor enumCellEditor;
    private TextCellEditor floatCellEditor;
    private TextCellEditor intCellEditor;
    private TextCellEditor longCellEditor;
    private ResourceSet resource;
    private TextCellEditor shortCellEditor;
    private TextCellEditor stringCellEditor;

    public ParameterBindingEditingSupport(TableViewer viewer, Map<EParameter, Object> bindings) {
        super((ColumnViewer)viewer);
        this.bindings = bindings;
        this.dialog = new SelectEClassifierBindingDialog();
        this.booleanCellEditor = new CheckboxCellEditor((Composite)this.getTable());
        this.byteCellEditor = new TextCellEditor((Composite)this.getTable());
        this.byteCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                try {
                    Byte.parseByte((String)value);
                    return null;
                }
                catch (Exception exception) {
                    return "This is not a valid byte value.";
                }
            }
        });
        this.shortCellEditor = new TextCellEditor((Composite)this.getTable());
        this.shortCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                try {
                    Short.parseShort((String)value);
                    return null;
                }
                catch (Exception exception) {
                    return "This is not a valid short value.";
                }
            }
        });
        this.charTextCellEditor = new TextCellEditor((Composite)this.getTable());
        this.charTextCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                try {
                    if (((String)value).length() == 1) {
                        return null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "This is not a valid character.";
            }
        });
        this.intCellEditor = new TextCellEditor((Composite)this.getTable());
        this.intCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                try {
                    Integer.parseInt((String)value);
                    return null;
                }
                catch (Exception exception) {
                    return "This is not a valid integer value.";
                }
            }
        });
        this.floatCellEditor = new TextCellEditor((Composite)this.getTable());
        this.floatCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                try {
                    Float.parseFloat((String)value);
                    return null;
                }
                catch (Exception exception) {
                    return "This is not a valid float value.";
                }
            }
        });
        this.longCellEditor = new TextCellEditor((Composite)this.getTable());
        this.longCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                try {
                    Long.parseLong((String)value);
                    return null;
                }
                catch (Exception exception) {
                    return "This is not a valid long value.";
                }
            }
        });
        this.doubleCellEditor = new TextCellEditor((Composite)this.getTable());
        this.doubleCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                try {
                    Double.parseDouble((String)value);
                    return null;
                }
                catch (Exception exception) {
                    return "The value is not a valid integer.";
                }
            }
        });
        this.enumCellEditor = new ComboBoxCellEditor((Composite)this.getTable(), new String[0], 8);
        this.stringCellEditor = new TextCellEditor((Composite)this.getTable());
        this.stringCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                if (value instanceof String && !((String)value).isEmpty()) {
                    return null;
                }
                return "The input is not a valid String.";
            }
        });
        this.dialogCellEditor = new DialogCellEditor((Composite)this.getTable()){

            protected Object openDialogBox(Control control) {
                if (ParameterBindingEditingSupport.this.dialog.open() == 0) {
                    return ParameterBindingEditingSupport.this.dialog.getElement();
                }
                return null;
            }
        };
    }

    private Table getTable() {
        return this.getViewer().getTable();
    }

    protected void setValue(Object element, Object value) {
        Object newValue;
        switch (TypeUtil.getType((Object)element)) {
            case BOOLEAN: {
                newValue = Boolean.valueOf(String.valueOf(value));
                break;
            }
            case BYTE: {
                newValue = Byte.valueOf((String)value);
                break;
            }
            case SHORT: {
                newValue = Short.valueOf((String)value);
                break;
            }
            case CHAR: {
                newValue = Character.valueOf(((String)value).charAt(0));
                break;
            }
            case INTEGER: {
                newValue = Integer.valueOf((String)value);
                break;
            }
            case LONG: {
                newValue = Long.valueOf((String)value);
                break;
            }
            case FLOAT: {
                newValue = Float.valueOf((String)value);
                break;
            }
            case DOUBLE: {
                newValue = Double.valueOf((String)value);
                break;
            }
            case ENUM: {
                newValue = TypeUtil.getLiteral((Object)element, (Integer)((Integer)value));
                break;
            }
            case STRING: {
                newValue = value;
                break;
            }
            case UNKNOWN: {
                newValue = value;
                break;
            }
            default: {
                newValue = null;
            }
        }
        this.bindings.put((EParameter)element, newValue);
        this.getViewer().refresh(element);
    }

    public TableViewer getViewer() {
        return (TableViewer)super.getViewer();
    }

    public void setResource(ResourceSet resourceSet) {
        this.resource = resourceSet;
    }

    protected Object getValue(Object element) {
        TypeUtil.Type type = TypeUtil.getType((Object)element);
        if (TypeUtil.Type.ENUM.equals((Object)type)) {
            return TypeUtil.getIndex((Object)element, (Object)this.bindings.get(element));
        }
        if (TypeUtil.Type.BOOLEAN.equals((Object)type)) {
            return this.bindings.get(element);
        }
        if (TypeUtil.Type.UNKNOWN.equals((Object)type)) {
            return this.bindings.get(element);
        }
        return String.valueOf(this.bindings.get(element));
    }

    protected boolean canEdit(Object element) {
        return element instanceof EParameter;
    }

    protected CellEditor getCellEditor(Object element) {
        switch (TypeUtil.getType((Object)element)) {
            case BOOLEAN: {
                return this.booleanCellEditor;
            }
            case BYTE: {
                return this.byteCellEditor;
            }
            case SHORT: {
                return this.shortCellEditor;
            }
            case CHAR: {
                return this.charTextCellEditor;
            }
            case INTEGER: {
                return this.intCellEditor;
            }
            case LONG: {
                return this.longCellEditor;
            }
            case FLOAT: {
                return this.floatCellEditor;
            }
            case DOUBLE: {
                return this.doubleCellEditor;
            }
            case ENUM: {
                this.enumCellEditor.setItems(TypeUtil.getEnumItems((Object)element));
                return this.enumCellEditor;
            }
            case STRING: {
                return this.stringCellEditor;
            }
            case UNKNOWN: {
                this.dialog.setType(((EParameter)element).getEType());
                this.dialog.setSelectedElement((EObject)this.bindings.get(element));
                this.dialog.setResource(this.resource);
                return this.dialogCellEditor;
            }
        }
        return null;
    }
}

