/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.ocl;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.storydriven.storydiagrams.diagram.ocl.ColorManager;

public class OCLCollectionTupleRule
extends WordRule {
    private static final String[] KEYWORDS = new String[]{"Set", "OrderedSet", "Bag", "Sequence", "Tuple"};
    private static final String[] BRACES = new String[]{"{", "}", "}}", "}}}"};

    public OCLCollectionTupleRule(ColorManager colorManager, boolean isBraces) {
        super((IWordDetector)new CollectionTupleDetector(isBraces));
        Token token = new Token((Object)new TextAttribute(colorManager.getColor(ColorManager.COLLECTION_TUPLE), null, 1));
        if (isBraces) {
            String[] stringArray = BRACES;
            int n = BRACES.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                this.addWord(word, (IToken)token);
                ++n2;
            }
        } else {
            String[] stringArray = KEYWORDS;
            int n = KEYWORDS.length;
            int n3 = 0;
            while (n3 < n) {
                String word = stringArray[n3];
                this.addWord(word, (IToken)token);
                ++n3;
            }
        }
    }

    private static class CollectionTupleDetector
    implements IWordDetector {
        private final boolean isBraces;

        public CollectionTupleDetector(boolean isBraces) {
            this.isBraces = isBraces;
        }

        public boolean isWordPart(char c) {
            return this.isBraces ? c == '{' || c == '}' : c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        }

        public boolean isWordStart(char c) {
            return this.isWordPart(c);
        }
    }
}

