/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.ocl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ConstraintKind;
import org.storydriven.storydiagrams.diagram.ocl.OCLPartitionScanner;

public class OCLDocument
extends Document {
    private OCL ocl = OCL.newInstance();
    private OCL.Helper oclHelper = this.ocl.createOCLHelper();
    private EClassifier contextClassifier;

    public OCLDocument() {
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new OCLPartitionScanner(), new String[]{"__ocl_comment"});
        partitioner.connect((IDocument)this);
        this.setDocumentPartitioner((IDocumentPartitioner)partitioner);
    }

    public void setOCLContextInformation(Map<String, EClassifier> contextInformation) {
        for (String string : contextInformation.keySet()) {
            Variable var = this.ocl.getEnvironment().getOCLFactory().createVariable();
            var.setName(string);
            var.setType((Object)this.getOclType(contextInformation.get(string), this.ocl));
            this.ocl.getEnvironment().addElement(string, var, true);
        }
    }

    private EClassifier getOclType(EClassifier classifier, OCL ocl) {
        return classifier;
    }

    public EClassifier getOCLContext() {
        return this.contextClassifier;
    }

    public Collection<Variable<EClassifier, EParameter>> getOCLContextInformation() {
        return this.ocl.getEnvironment().getVariables();
    }

    public List<Choice> getOCLChoices(int offset) {
        if (this.contextClassifier == null) {
            this.setOCLContext((EClassifier)EcorePackage.Literals.EOBJECT);
            List<Choice> l = this.getOCLChoices(offset);
            this.setOCLContext(null);
            return l;
        }
        try {
            String text = this.get(0, offset);
            return this.oclHelper.getSyntaxHelp(ConstraintKind.INVARIANT, text);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public void setOCLContext(EClassifier context) {
        this.contextClassifier = context;
        this.oclHelper.setContext((Object)context);
    }
}

