/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.ocl;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.storydriven.storydiagrams.diagram.ocl.ColorManager;
import org.storydriven.storydiagrams.diagram.ocl.OCLCommentScanner;
import org.storydriven.storydiagrams.diagram.ocl.OCLCompletionProcessor;
import org.storydriven.storydiagrams.diagram.ocl.OCLDocument;
import org.storydriven.storydiagrams.diagram.ocl.OCLScanner;

public class OCLSourceViewerConfiguration
extends SourceViewerConfiguration {
    private OCLScanner oclScanner;
    private OCLCommentScanner oclCommentScanner;
    private ColorManager colorManager;
    private OCLDocument oclDocument;

    public OCLSourceViewerConfiguration(ColorManager colorManager, OCLDocument oclDocument) {
        this.colorManager = colorManager;
        this.oclDocument = oclDocument;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getOCLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getOCLCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ocl_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ocl_comment");
        return reconciler;
    }

    protected OCLScanner getOCLScanner() {
        if (this.oclScanner == null) {
            this.oclScanner = new OCLScanner(this.colorManager, this.oclDocument);
            this.oclScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ColorManager.DEFAULT))));
        }
        return this.oclScanner;
    }

    protected OCLCommentScanner getOCLCommentScanner() {
        if (this.oclCommentScanner == null) {
            this.oclCommentScanner = new OCLCommentScanner(this.colorManager);
            this.oclCommentScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ColorManager.COMMENT))));
        }
        return this.oclCommentScanner;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__ocl_comment"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant result = new ContentAssistant();
        result.setContentAssistProcessor((IContentAssistProcessor)new OCLCompletionProcessor(), "__dftl_partition_content_type");
        result.enableAutoActivation(true);
        return result;
    }
}

