/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.storydriven.storydiagrams.activities.ActivitiesPackage;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.diagram.part.StorydiagramsDiagramEditorPlugin;
import org.storydriven.storydiagrams.patterns.PatternsPackage;

public class StorydiagramsVisualIDRegistry {
    private static final String DEBUG_KEY = "org.storydriven.storydiagrams.diagram/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Storydiagrams".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return StorydiagramsVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                StorydiagramsDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (ActivitiesPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass()) && StorydiagramsVisualIDRegistry.isDiagram((Activity)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = StorydiagramsVisualIDRegistry.getModelID(containerView);
        if (!"Storydiagrams".equals(containerModelID)) {
            return -1;
        }
        if ("Storydiagrams".equals(containerModelID)) {
            containerVisualID = StorydiagramsVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (ActivitiesPackage.eINSTANCE.getActivityCallNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (ActivitiesPackage.eINSTANCE.getStatementNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (ActivitiesPackage.eINSTANCE.getModifyingStoryNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (ActivitiesPackage.eINSTANCE.getMatchingStoryNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2004;
                }
                if (ActivitiesPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (ActivitiesPackage.eINSTANCE.getJunctionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (ActivitiesPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2007;
                }
                if (!ActivitiesPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) break;
                return 2008;
            }
            case 7001: {
                if (!PatternsPackage.eINSTANCE.getStoryPattern().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7002: {
                if (PatternsPackage.eINSTANCE.getCollectionVariable().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (!PatternsPackage.eINSTANCE.getObjectVariable().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7003: {
                if (!PatternsPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3006;
            }
            case 7004: {
                if (!PatternsPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 7005: {
                if (!PatternsPackage.eINSTANCE.getAttributeAssignment().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7006: {
                if (!PatternsPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 7007: {
                if (!PatternsPackage.eINSTANCE.getAttributeAssignment().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7008: {
                if (!PatternsPackage.eINSTANCE.getMatchingPattern().isSuperTypeOf(domainElement.eClass())) break;
                return 3007;
            }
            case 7009: {
                if (PatternsPackage.eINSTANCE.getCollectionVariable().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (!PatternsPackage.eINSTANCE.getObjectVariable().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7010: {
                if (!PatternsPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3006;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = StorydiagramsVisualIDRegistry.getModelID(containerView);
        if (!"Storydiagrams".equals(containerModelID)) {
            return false;
        }
        if ("Storydiagrams".equals(containerModelID)) {
            containerVisualID = StorydiagramsVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2008 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5002 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (5004 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5011 == nodeVisualID) {
                    return true;
                }
                if (7001 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (5012 == nodeVisualID) {
                    return true;
                }
                if (7008 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5013 != nodeVisualID) break;
                return true;
            }
            case 2008: {
                if (5014 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 3005: {
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (5010 == nodeVisualID) {
                    return true;
                }
                if (7006 == nodeVisualID) {
                    return true;
                }
                if (7007 != nodeVisualID) break;
                return true;
            }
            case 3007: {
                if (7009 == nodeVisualID) {
                    return true;
                }
                if (7010 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3004 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3004 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (6003 == nodeVisualID) {
                    return true;
                }
                if (6004 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (6005 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (6006 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (ActivitiesPackage.eINSTANCE.getActivityEdge().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (PatternsPackage.eINSTANCE.getLinkVariable().isSuperTypeOf(domainElement.eClass())) {
            return 4002;
        }
        if (PatternsPackage.eINSTANCE.getInclusionLink().isSuperTypeOf(domainElement.eClass())) {
            return 4003;
        }
        if (PatternsPackage.eINSTANCE.getMaybeLink().isSuperTypeOf(domainElement.eClass())) {
            return 4004;
        }
        return -1;
    }

    private static boolean isDiagram(Activity element) {
        return true;
    }
}

