/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.expressions.pathExpressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ImplicitPathKind implements Enumerator
{
    ANY(0, "ANY", "-->"),
    CONTAINMENT_SOURCE(1, "CONTAINMENT_SOURCE", "<>-->"),
    CONTAINMENT_TARGET(2, "CONTAINMENT_TARGET", "--><>");

    public static final int ANY_VALUE = 0;
    public static final int CONTAINMENT_SOURCE_VALUE = 1;
    public static final int CONTAINMENT_TARGET_VALUE = 2;
    private static final ImplicitPathKind[] VALUES_ARRAY;
    public static final List<ImplicitPathKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ImplicitPathKind[]{ANY, CONTAINMENT_SOURCE, CONTAINMENT_TARGET};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ImplicitPathKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImplicitPathKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImplicitPathKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImplicitPathKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImplicitPathKind get(int value) {
        switch (value) {
            case 0: {
                return ANY;
            }
            case 1: {
                return CONTAINMENT_SOURCE;
            }
            case 2: {
                return CONTAINMENT_TARGET;
            }
        }
        return null;
    }

    private ImplicitPathKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

