/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.interpreter.patternmatcher;

import de.mdelab.sdm.interpreter.core.SDMException;
import de.mdelab.sdm.interpreter.core.notifications.Notifier;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.ECheckResult;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.EMatchType;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.MatchState;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.PatternPartBasedMatcher;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.storydriven.core.expressions.Expression;
import org.storydriven.storydiagrams.expressions.pathExpressions.ExplicitPathDescription;
import org.storydriven.storydiagrams.expressions.pathExpressions.ImplicitPathDescription;
import org.storydriven.storydiagrams.expressions.pathExpressions.ImplicitPathKind;
import org.storydriven.storydiagrams.expressions.pathExpressions.PathExpression;
import org.storydriven.storydiagrams.expressions.pathExpressions.PathSegment;
import org.storydriven.storydiagrams.expressions.pathExpressions.PathSegmentDescription;
import org.storydriven.storydiagrams.expressions.pathExpressions.RepeatOperator;
import org.storydriven.storydiagrams.expressions.pathExpressions.RestrictionList;
import org.storydriven.storydiagrams.expressions.pathExpressions.TypeRestriction;
import org.storydriven.storydiagrams.expressions.pathbridge.PathExpressionBridge;
import org.storydriven.storydiagrams.interpreter.patternmatcher.StoryDrivenPatternPart;
import org.storydriven.storydiagrams.patterns.AbstractLinkVariable;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.Path;

public class StoryDrivenPathPatternPart
extends StoryDrivenPatternPart<AbstractVariable, Path> {
    private static final int ALLOWED = 1;
    private static final int NOT_MENTIONED = 0;
    private static final int RESTRICTED = -1;

    public StoryDrivenPathPatternPart(PatternPartBasedMatcher<?, ?, ?, ?, AbstractVariable, AbstractLinkVariable, EClassifier, ?, Expression> patternMatcher, Path link) {
        super(patternMatcher, (AbstractLinkVariable)link, new AbstractVariable[]{link.getSource(), link.getTarget()});
    }

    @Override
    protected EMatchType doGetMatchType() {
        switch (((Path)this.link).getBindingOperator()) {
            case CHECK_ONLY: {
                switch (((Path)this.link).getBindingSemantics()) {
                    case MANDATORY: {
                        return EMatchType.MANDATORY;
                    }
                    case OPTIONAL: {
                        return EMatchType.OPTIONAL;
                    }
                    case NEGATIVE: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            case CREATE: {
                throw new UnsupportedOperationException();
            }
            case DESTROY: {
                switch (((Path)this.link).getBindingSemantics()) {
                    case MANDATORY: {
                        return EMatchType.MANDATORY;
                    }
                    case OPTIONAL: {
                        return EMatchType.OPTIONAL;
                    }
                    case NEGATIVE: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doCreateLink() {
    }

    @Override
    protected void doDestroyLink(Map<AbstractVariable, Object> deletedObjects) {
    }

    public ECheckResult check() throws SDMException {
        if (this.patternMatcher.isBound((Object)((Path)this.link).getSource()) && this.patternMatcher.isBound((Object)((Path)this.link).getTarget())) {
            ObjectVariable sourceSpo = ((Path)this.link).getSource();
            AbstractVariable targetSpo = ((Path)this.link).getTarget();
            Variable sourceVariable = this.patternMatcher.getVariablesScope().getVariable(sourceSpo.getName());
            Variable targetVariable = this.patternMatcher.getVariablesScope().getVariable(targetSpo.getName());
            if (sourceVariable != null && targetVariable != null) {
                assert (sourceVariable.getValue() != null);
                assert (targetVariable.getValue() != null);
                assert (sourceVariable.getValue() instanceof EObject);
                EObject sourceInstanceObject = (EObject)sourceVariable.getValue();
                Object targetInstanceObject = targetVariable.getValue();
                Variable<EClassifier> result = this.applyPathMatching(sourceInstanceObject);
                if (result.getValue() instanceof Collection) {
                    if (((Collection)result.getValue()).contains(targetInstanceObject)) {
                        this.patternMatcher.getNotificationEmitter().linkCheckSuccessful((Object)sourceSpo, (Object)sourceInstanceObject, (Object)this.link, (Object)targetSpo, targetInstanceObject, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
                        return ECheckResult.OK;
                    }
                    this.patternMatcher.getNotificationEmitter().linkCheckFailed((Object)sourceSpo, (Object)sourceInstanceObject, (Object)this.link, (Object)targetSpo, targetInstanceObject, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
                    return ECheckResult.FAIL;
                }
                if (result.getValue() == targetInstanceObject) {
                    this.patternMatcher.getNotificationEmitter().linkCheckSuccessful((Object)sourceSpo, (Object)sourceInstanceObject, (Object)this.link, (Object)targetSpo, targetInstanceObject, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
                    return ECheckResult.OK;
                }
                this.patternMatcher.getNotificationEmitter().linkCheckFailed((Object)sourceSpo, (Object)sourceInstanceObject, (Object)this.link, (Object)targetSpo, targetInstanceObject, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
                return ECheckResult.FAIL;
            }
            return ECheckResult.UNKNOWN;
        }
        return ECheckResult.UNKNOWN;
    }

    public boolean match(MatchState matchState) throws SDMException {
        ObjectVariable sourceVar = ((Path)this.link).getSource();
        AbstractVariable targetVar = ((Path)this.link).getTarget();
        assert (this.patternMatcher.isBound((Object)sourceVar) || this.patternMatcher.isBound((Object)targetVar));
        assert (!this.patternMatcher.isBound((Object)sourceVar) || !this.patternMatcher.isBound((Object)targetVar));
        assert (this.patternMatcher.isBound((Object)sourceVar));
        Variable sourceVariable = this.patternMatcher.getVariablesScope().getVariable(sourceVar.getName());
        assert (sourceVariable != null);
        assert (sourceVariable.getValue() instanceof EObject);
        EObject sourceInstanceObject = (EObject)sourceVariable.getValue();
        this.patternMatcher.getNotificationEmitter().traversingLink((Object)this.link, (Object)sourceVar, (Object)sourceInstanceObject, (Object)targetVar, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
        Variable<EClassifier> result = this.applyPathMatching(sourceInstanceObject);
        assert (result != null);
        if (result.getValue() instanceof Collection) {
            for (Object targetObject : (Collection)result.getValue()) {
                if (!this.patternMatcher.matchStoryPatternObject((Object)targetVar, targetObject)) continue;
                return true;
            }
        } else if (result.getValue() != null && this.patternMatcher.matchStoryPatternObject((Object)targetVar, result.getValue())) {
            return true;
        }
        this.patternMatcher.getNotificationEmitter().storyPatternObjectNotBound((Object)targetVar, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
        return false;
    }

    public int calculateMatchingCost() {
        assert (!this.patternMatcher.isBound((Object)((Path)this.link).getSource()) || !this.patternMatcher.isBound((Object)((Path)this.link).getTarget()));
        if (this.patternMatcher.isBound((Object)((Path)this.link).getSource())) {
            return 0x7FFFFFFE;
        }
        return -1;
    }

    public MatchState createMatchState() {
        return null;
    }

    private Variable<EClassifier> applyPathMatching(EObject sourceObject) {
        LinkedList<EObject> results = new LinkedList<EObject>();
        Path path = (Path)this.link;
        PathExpressionBridge bridge = (PathExpressionBridge)path.getPathExpression();
        PathExpression expr = bridge.getPathExpression();
        for (org.storydriven.storydiagrams.expressions.pathExpressions.Path pa : expr.getPathAlternatives()) {
            List<EObject> tmp = this.applySearchForPathAlternative(sourceObject, pa);
            results.addAll(tmp);
        }
        return new Variable(((Path)this.link).getName() == null ? "path" : ((Path)this.link).getName(), (Object)((Path)this.link).getTarget().getType(), results);
    }

    private List<EObject> applySearchForPathAlternative(EObject sourceObject, org.storydriven.storydiagrams.expressions.pathExpressions.Path pa) {
        LinkedList<EObject> results = new LinkedList<EObject>();
        LinkedList<EObject> visited = new LinkedList<EObject>();
        LinkedList<EObject> queue = new LinkedList<EObject>();
        List<Object> reached = Collections.emptyList();
        queue.offer(sourceObject);
        for (PathSegment segment : pa.getSegments()) {
            reached = this.checkNextSegment(visited, queue, segment);
            for (EObject eObject : reached) {
                queue.offer(eObject);
            }
        }
        results.addAll(reached);
        return results;
    }

    private List<EObject> checkNextSegment(List<EObject> visited, LinkedList<EObject> queue, PathSegment segment) {
        LinkedList<EObject> intermediateResult = new LinkedList<EObject>();
        RepeatOperator operator = segment.getRepeatOperator();
        if (operator == RepeatOperator.ARBITRARY) {
            intermediateResult.addAll(queue);
        }
        while (!queue.isEmpty()) {
            EObject node = queue.pop();
            if (visited.contains(node)) continue;
            visited.add(node);
            List<EObject> neighbors = this.getNodeNeighbors(node, segment);
            for (EObject neighbor : neighbors) {
                if (visited.contains(neighbor)) continue;
                if (operator != RepeatOperator.NO_REPEAT) {
                    queue.offer(neighbor);
                }
                intermediateResult.add(neighbor);
            }
        }
        return intermediateResult;
    }

    private List<EObject> getNodeNeighbors(EObject node, PathSegment segment) {
        EClass classifier = node.eClass();
        LinkedList<EObject> neighbors = new LinkedList<EObject>();
        List<EObject> tmp = null;
        for (PathSegmentDescription desc : segment.getAlternatives()) {
            if (desc instanceof ExplicitPathDescription) {
                ExplicitPathDescription exDesc = (ExplicitPathDescription)desc;
                String name = exDesc.getAssociationName();
                for (EReference ref : classifier.getEAllReferences()) {
                    if (!name.equals(ref.getName())) continue;
                    tmp = this.getFilteredNeighbors(node, ref, (PathSegmentDescription)exDesc);
                    neighbors.addAll(tmp);
                }
                continue;
            }
            if (!(desc instanceof ImplicitPathDescription)) continue;
            ImplicitPathDescription imDesc = (ImplicitPathDescription)desc;
            ImplicitPathKind kind = imDesc.getKind();
            for (EReference ref : classifier.getEAllReferences()) {
                if (!(kind == ImplicitPathKind.CONTAINMENT_SOURCE && ref.isContainment() || kind == ImplicitPathKind.CONTAINMENT_TARGET && ref.isContainer()) && kind != ImplicitPathKind.ANY) continue;
                tmp = this.getFilteredNeighbors(node, ref, (PathSegmentDescription)imDesc);
                neighbors.addAll(tmp);
            }
        }
        return neighbors;
    }

    private List<EObject> getFilteredNeighbors(EObject node, EReference ref, PathSegmentDescription desc) {
        LinkedList<EObject> neighbors = new LinkedList<EObject>();
        LinkedList<EObject> targets = new LinkedList<EObject>();
        if (ref.isMany()) {
            targets.addAll((List)node.eGet((EStructuralFeature)ref));
        } else if (node.eIsSet((EStructuralFeature)ref)) {
            targets.add((EObject)node.eGet((EStructuralFeature)ref));
        }
        for (EObject target : targets) {
            int chkResult = this.checkTypeRestrictions(desc, target);
            if (chkResult == -1) continue;
            neighbors.add(target);
        }
        return neighbors;
    }

    private int checkTypeRestrictions(PathSegmentDescription desc, EObject target) {
        if (desc.getRestrictionList() == null) {
            return 1;
        }
        EClass cl = target.eClass();
        RestrictionList rest = desc.getRestrictionList();
        for (TypeRestriction typeRest : rest.getRestrictions()) {
            if (!cl.getName().equals(typeRest.getTypeName())) continue;
            if (typeRest.isForbidden()) {
                return -1;
            }
            return 1;
        }
        return 0;
    }
}

