/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.ui.properties;

import de.upb.swt.core.ui.CoreImages;
import de.upb.swt.core.ui.properties.sections.AbstractPropertySection;
import de.upb.swt.core.ui.providers.ComposedAdapterFactoryLabelProvider;
import de.upb.swt.core.ui.providers.ContainmentContentProvider;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.storydriven.core.expressions.Expression;
import org.storydriven.core.expressions.ExpressionsFactory;
import org.storydriven.core.expressions.TextualExpression;
import org.storydriven.core.expressions.common.ArithmeticExpression;
import org.storydriven.core.expressions.common.ArithmeticOperator;
import org.storydriven.core.expressions.common.BinaryExpression;
import org.storydriven.core.expressions.common.CommonExpressionsFactory;
import org.storydriven.core.expressions.common.CommonExpressionsPackage;
import org.storydriven.core.expressions.common.ComparingOperator;
import org.storydriven.core.expressions.common.ComparisonExpression;
import org.storydriven.core.expressions.common.LiteralExpression;
import org.storydriven.core.expressions.common.LogicOperator;
import org.storydriven.core.expressions.common.LogicalExpression;
import org.storydriven.core.expressions.common.UnaryExpression;
import org.storydriven.core.expressions.util.ExpressionUtils;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.expressions.ActivitiesExpressionsFactory;
import org.storydriven.storydiagrams.calls.expressions.CallsExpressionsFactory;
import org.storydriven.storydiagrams.diagram.custom.util.ActivityUtil;
import org.storydriven.storydiagrams.diagram.custom.util.BoundUtil;
import org.storydriven.storydiagrams.diagram.custom.util.TextUtil;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.PrimitiveVariable;
import org.storydriven.storydiagrams.patterns.expressions.AttributeValueExpression;
import org.storydriven.storydiagrams.patterns.expressions.ObjectVariableExpression;
import org.storydriven.storydiagrams.patterns.expressions.PatternsExpressionsFactory;
import org.storydriven.storydiagrams.patterns.expressions.PatternsExpressionsPackage;
import org.storydriven.storydiagrams.patterns.expressions.PrimitiveVariableExpression;
import org.storydriven.storydiagrams.ui.SourceViewerProvider;

public abstract class AbstractExtendedExpressionSection
extends AbstractPropertySection {
    private static final String EXPRESSION_SOURCE_VIEWER_EXTENSION_POINT_ID = "org.storydriven.storydiagrams.diagram.custom.expressionSourceViewerExtension";
    private static final String EXPRESSION_LANGUAGES_LANGUAGE_ATTRIBUTE_NAME = "expressionLanguage";
    private static final String EXPRESSION_LANGUAGES_VERSION_ATTRIBUTE_NAME = "version";
    private static final String EXPRESSION_SOURCE_VIEWER_ATTRIBUTE_NAME = "sourceViewerProvider";
    private static HashMap<String, SourceViewerProvider> sourceViewerProviders;
    private Group group;
    private Composite viewerComposite;
    private Composite createComposite;
    private SashForm treeForm;
    private Composite treeViewerWrapperComposite;
    private TreeViewer treeViewer;
    private Composite treePropertiesWrapperComposite;
    private Composite treePropertiesComposite;
    private ISourceViewer sourceViewer;
    private Button removeButton;
    private SourceViewerProvider provider;
    private Composite emptyPC;
    private Composite literalPC;
    private Composite comparisonPC;
    private Composite arithmeticPC;
    private Composite logicPC;
    private Composite attributePC;
    private Combo logicOperatorCombo;
    private Combo arithmeticOperatorCombo;
    private Combo comparisonOperatorCombo;
    private Text literalValueText;
    private Map<String, ObjectVariable> objectVariables = new LinkedHashMap<String, ObjectVariable>();
    private Map<String, PrimitiveVariable> primitiveVariables = new LinkedHashMap<String, PrimitiveVariable>();
    private Map<String, EAttribute> attributes = new LinkedHashMap<String, EAttribute>();
    private ComposedAdapterFactoryLabelProvider labelProvider;
    private Combo oveVariableCombo;
    private Composite ovePC;
    private Composite pvePC;
    private Combo pveVariableCombo;
    private Combo attributesObjectCombo;
    private Combo attributesCombo;

    public AbstractExtendedExpressionSection() {
        AbstractExtendedExpressionSection.initializeSourceViewerProviders();
    }

    private static void initializeSourceViewerProviders() {
        if (sourceViewerProviders == null && Platform.getExtensionRegistry() != null) {
            IConfigurationElement[] configurationElements;
            sourceViewerProviders = new HashMap();
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXPRESSION_SOURCE_VIEWER_EXTENSION_POINT_ID);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                String s = configurationElement.getAttribute(EXPRESSION_LANGUAGES_LANGUAGE_ATTRIBUTE_NAME);
                String v = configurationElement.getAttribute(EXPRESSION_LANGUAGES_VERSION_ATTRIBUTE_NAME);
                if (s != null && !"".equals(s) && v != null && !"".equals(v)) {
                    try {
                        sourceViewerProviders.put(s.concat(v), (SourceViewerProvider)configurationElement.createExecutableExtension(EXPRESSION_SOURCE_VIEWER_ATTRIBUTE_NAME));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        for (String aLanguage : ExpressionUtils.getAvailableExpressionLanguages()) {
            for (String aVersion : ExpressionUtils.getAvailableExpressionLanguageVersions((String)aLanguage)) {
                if (sourceViewerProviders.containsKey(aLanguage.concat(aVersion))) continue;
                sourceViewerProviders.put(aLanguage.concat(aVersion), new SourceViewerProvider());
            }
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void dispose() {
        if (this.provider != null) {
            this.provider.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
        super.dispose();
    }

    protected void createWidgets(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        this.labelProvider = new ComposedAdapterFactoryLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EObject) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(AbstractExtendedExpressionSection.this.getEClassName((EObject)element));
                    builder.append(' ');
                    if (element instanceof ArithmeticExpression) {
                        builder.append(TextUtil.getText((ArithmeticOperator)((ArithmeticExpression)element).getOperator()));
                    } else if (element instanceof ComparisonExpression) {
                        builder.append(TextUtil.getText((ComparingOperator)((ComparisonExpression)element).getOperator()));
                    } else if (element instanceof LogicalExpression) {
                        builder.append(TextUtil.getText((LogicOperator)((LogicalExpression)element).getOperator()));
                    } else if (!(element instanceof UnaryExpression)) {
                        if (element instanceof Expression) {
                            builder.append(TextUtil.getText((Expression)((Expression)element)));
                        } else {
                            builder.append(element);
                        }
                    }
                    return builder.toString();
                }
                return super.getText(element);
            }
        };
        this.group = factory.createGroup(parent, this.getLabelText());
        this.viewerComposite = factory.createFlatFormComposite((Composite)this.group);
        this.createComposite = factory.createFlatFormComposite(this.viewerComposite);
        this.fillCreateComposite(factory);
        this.treeForm = new SashForm(this.viewerComposite, 0);
        factory.adapt((Composite)this.treeForm);
        this.treeViewerWrapperComposite = factory.createFlatFormComposite((Composite)this.treeForm);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(this.treeViewerWrapperComposite);
        Tree tree = factory.createTree(this.treeViewerWrapperComposite, 2052);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new ContainmentContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setAutoExpandLevel(-1);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.treeViewer.getControl());
        this.treePropertiesWrapperComposite = factory.createFlatFormComposite((Composite)this.treeForm);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(this.treePropertiesWrapperComposite);
        this.treePropertiesComposite = factory.createFlatFormComposite(this.treePropertiesWrapperComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.treePropertiesComposite);
        this.createPropertyWidgets(factory);
        this.removeButton = factory.createButton((Composite)this.group, "Remove Expression", 8);
    }

    protected String getLabelText() {
        return "Expression";
    }

    private void fillCreateComposite(TabbedPropertySheetWidgetFactory factory) {
        Button comparisonButton = factory.createButton(this.createComposite, "Comparison Expression", 8);
        comparisonButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExtendedExpressionSection.this.internalSetExpression((Expression)CommonExpressionsFactory.eINSTANCE.createComparisonExpression());
            }
        });
        Button objectButton = factory.createButton(this.createComposite, "Object Variable Expression", 8);
        objectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExtendedExpressionSection.this.internalSetExpression((Expression)PatternsExpressionsFactory.eINSTANCE.createObjectVariableExpression());
            }
        });
        Button primitiveButton = factory.createButton(this.createComposite, "Primitive Variable Expression", 8);
        primitiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExtendedExpressionSection.this.internalSetExpression((Expression)PatternsExpressionsFactory.eINSTANCE.createPrimitiveVariableExpression());
            }
        });
        Button logicButton = factory.createButton(this.createComposite, "Logic Expression", 8);
        logicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExtendedExpressionSection.this.internalSetExpression((Expression)CommonExpressionsFactory.eINSTANCE.createLogicalExpression());
            }
        });
        Button arithmeticButton = factory.createButton(this.createComposite, "Arithmetic Expression", 8);
        arithmeticButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExtendedExpressionSection.this.internalSetExpression((Expression)CommonExpressionsFactory.eINSTANCE.createArithmeticExpression());
            }
        });
        Button stringLiteralButton = factory.createButton(this.createComposite, "Literal Expression", 8);
        stringLiteralButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExtendedExpressionSection.this.internalSetExpression((Expression)CommonExpressionsFactory.eINSTANCE.createLiteralExpression());
            }
        });
        Button textualItem = factory.createButton(this.createComposite, "Textual Expression", 8);
        textualItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextualExpression expression = ExpressionsFactory.eINSTANCE.createTextualExpression();
                expression.setLanguage("OCL");
                expression.setLanguageVersion("1.0");
                AbstractExtendedExpressionSection.this.internalSetExpression((Expression)expression);
            }
        });
    }

    private void createPropertyWidgets(TabbedPropertySheetWidgetFactory factory) {
        this.emptyPC = factory.createFlatFormComposite(this.treePropertiesComposite);
        this.literalPC = factory.createFlatFormComposite(this.treePropertiesComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.literalPC);
        factory.createLabel(this.literalPC, "Value:", 131072);
        this.literalValueText = factory.createText(this.literalPC, "", 2052);
        this.literalValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractExtendedExpressionSection.this.changeProperty((EStructuralFeature)CommonExpressionsPackage.Literals.LITERAL_EXPRESSION__VALUE, AbstractExtendedExpressionSection.this.literalValueText.getText());
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.literalValueText);
        this.comparisonPC = factory.createFlatFormComposite(this.treePropertiesComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.comparisonPC);
        factory.createLabel(this.comparisonPC, "Operator:", 131072);
        this.comparisonOperatorCombo = new Combo(this.comparisonPC, 8);
        factory.adapt((Composite)this.comparisonOperatorCombo);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.comparisonOperatorCombo);
        String[] items = new String[ComparingOperator.values().length];
        int i = 0;
        while (i < items.length) {
            items[i] = ComparingOperator.get((int)i).getName();
            ++i;
        }
        this.comparisonOperatorCombo.setItems(items);
        this.comparisonOperatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComparingOperator value = ComparingOperator.get((int)AbstractExtendedExpressionSection.this.comparisonOperatorCombo.getSelectionIndex());
                AbstractExtendedExpressionSection.this.changeProperty((EStructuralFeature)CommonExpressionsPackage.Literals.COMPARISON_EXPRESSION__OPERATOR, value);
            }
        });
        this.arithmeticPC = factory.createFlatFormComposite(this.treePropertiesComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.arithmeticPC);
        factory.createLabel(this.arithmeticPC, "Operator:", 131072);
        this.arithmeticOperatorCombo = new Combo(this.arithmeticPC, 8);
        factory.adapt((Composite)this.arithmeticOperatorCombo);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.arithmeticOperatorCombo);
        items = new String[ArithmeticOperator.values().length];
        i = 0;
        while (i < items.length) {
            items[i] = ArithmeticOperator.get((int)i).getName();
            ++i;
        }
        this.arithmeticOperatorCombo.setItems(items);
        this.arithmeticOperatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArithmeticOperator value = ArithmeticOperator.get((int)AbstractExtendedExpressionSection.this.arithmeticOperatorCombo.getSelectionIndex());
                AbstractExtendedExpressionSection.this.changeProperty((EStructuralFeature)CommonExpressionsPackage.Literals.ARITHMETIC_EXPRESSION__OPERATOR, value);
            }
        });
        this.logicPC = factory.createFlatFormComposite(this.treePropertiesComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.logicPC);
        factory.createLabel(this.logicPC, "Operator:", 131072);
        this.logicOperatorCombo = new Combo(this.logicPC, 8);
        factory.adapt((Composite)this.logicOperatorCombo);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.logicOperatorCombo);
        items = new String[LogicOperator.values().length];
        i = 0;
        while (i < items.length) {
            items[i] = LogicOperator.get((int)i).getName();
            ++i;
        }
        this.logicOperatorCombo.setItems(items);
        this.logicOperatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogicOperator value = LogicOperator.get((int)AbstractExtendedExpressionSection.this.logicOperatorCombo.getSelectionIndex());
                AbstractExtendedExpressionSection.this.changeProperty((EStructuralFeature)CommonExpressionsPackage.Literals.LOGICAL_EXPRESSION__OPERATOR, value);
            }
        });
        this.ovePC = factory.createFlatFormComposite(this.treePropertiesComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.ovePC);
        factory.createLabel(this.ovePC, "Variable:", 131072);
        this.oveVariableCombo = new Combo(this.ovePC, 8);
        factory.adapt((Composite)this.oveVariableCombo);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.oveVariableCombo);
        this.oveVariableCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExtendedExpressionSection.this.changeProperty((EStructuralFeature)PatternsExpressionsPackage.Literals.OBJECT_VARIABLE_EXPRESSION__OBJECT, AbstractExtendedExpressionSection.this.objectVariables.get(AbstractExtendedExpressionSection.this.oveVariableCombo.getText()));
            }
        });
        this.pvePC = factory.createFlatFormComposite(this.treePropertiesComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.pvePC);
        factory.createLabel(this.pvePC, "Variable:", 131072);
        this.pveVariableCombo = new Combo(this.pvePC, 8);
        factory.adapt((Composite)this.pveVariableCombo);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.pveVariableCombo);
        this.pveVariableCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExtendedExpressionSection.this.changeProperty((EStructuralFeature)PatternsExpressionsPackage.Literals.PRIMITIVE_VARIABLE_EXPRESSION__PRIMITIVE_VARIABLE, AbstractExtendedExpressionSection.this.primitiveVariables.get(AbstractExtendedExpressionSection.this.pveVariableCombo.getText()));
            }
        });
        this.attributePC = factory.createFlatFormComposite(this.treePropertiesComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.attributePC);
        factory.createLabel(this.attributePC, "Variable:", 131072);
        this.attributesObjectCombo = new Combo(this.attributePC, 8);
        factory.adapt((Composite)this.attributesObjectCombo);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.attributesObjectCombo);
        this.attributesObjectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExtendedExpressionSection.this.changeProperty((EStructuralFeature)PatternsExpressionsPackage.Literals.ATTRIBUTE_VALUE_EXPRESSION__OBJECT, AbstractExtendedExpressionSection.this.objectVariables.get(AbstractExtendedExpressionSection.this.attributesObjectCombo.getText()));
            }
        });
        factory.createLabel(this.attributePC, "Attribute:", 131072);
        this.attributesCombo = new Combo(this.attributePC, 8);
        factory.adapt((Composite)this.attributesCombo);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.attributesCombo);
        this.attributesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExtendedExpressionSection.this.changeProperty((EStructuralFeature)PatternsExpressionsPackage.Literals.ATTRIBUTE_VALUE_EXPRESSION__ATTRIBUTE, AbstractExtendedExpressionSection.this.attributes.get(AbstractExtendedExpressionSection.this.attributesCombo.getText()));
            }
        });
    }

    protected abstract void setExpression(Expression var1);

    protected void hookWidgetListeners() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractExtendedExpressionSection.this.showProperties();
                AbstractExtendedExpressionSection.this.fillMenu();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExtendedExpressionSection.this.removeExpression();
            }
        });
    }

    protected void layoutWidgets() {
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo((Composite)this.group);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.group.setLayoutData((Object)data);
        this.viewerComposite.setLayout((Layout)new StackLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewerComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.createComposite);
        this.treePropertiesComposite.setLayout((Layout)new StackLayout());
    }

    private void removeExpression() {
        if (this.getExpression() != null) {
            RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)this.getEditingDomain()){

                protected void doExecute() {
                    EcoreUtil.delete((EObject)AbstractExtendedExpressionSection.this.getExpression(), (boolean)true);
                }
            };
            this.execute((Command)command);
            this.refresh();
        }
    }

    private void internalSetExpression(final Expression expression) {
        RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)this.getEditingDomain()){

            protected void doExecute() {
                AbstractExtendedExpressionSection.this.setExpression(expression);
            }
        };
        this.execute((Command)command);
        this.refresh();
    }

    private void remove() {
        RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)this.getEditingDomain()){

            protected void doExecute() {
                IStructuredSelection selection = (IStructuredSelection)AbstractExtendedExpressionSection.this.treeViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (selected instanceof EObject) {
                        EcoreUtil.delete((EObject)((EObject)selected), (boolean)true);
                    }
                    ++n2;
                }
            }
        };
        this.execute((Command)command);
        this.refresh();
    }

    public void refresh() {
        Expression expression = this.getExpression();
        if (expression == null) {
            StackLayout layout = (StackLayout)this.viewerComposite.getLayout();
            layout.topControl = this.createComposite;
        } else if (expression instanceof TextualExpression) {
            System.out.println("show the source viewer");
            EClassifier classifier = this.getContextClassifier();
            String value = ((TextualExpression)expression).getExpressionText();
            if (this.provider == null) {
                this.provider = sourceViewerProviders.get("OCL1.0");
            }
            if (this.sourceViewer != null) {
                this.sourceViewer.getTextWidget().dispose();
                this.sourceViewer = null;
            }
            this.sourceViewer = this.provider.createSourceViewer(this.viewerComposite, 2816, classifier, this.getContextInformation(), value);
            this.sourceViewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    final Expression expression = AbstractExtendedExpressionSection.this.getExpression();
                    if (expression instanceof TextualExpression) {
                        RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)AbstractExtendedExpressionSection.this.getEditingDomain()){

                            protected void doExecute() {
                                ((TextualExpression)expression).setExpressionText(AbstractExtendedExpressionSection.this.sourceViewer.getDocument().get());
                                Expression expression2 = AbstractExtendedExpressionSection.this.getExpression();
                                AbstractExtendedExpressionSection.this.setExpression(null);
                                AbstractExtendedExpressionSection.this.setExpression(expression2);
                            }
                        };
                        AbstractExtendedExpressionSection.this.execute((Command)command);
                    }
                }
            });
            this.provider.setText(value);
            StackLayout layout = (StackLayout)this.viewerComposite.getLayout();
            layout.topControl = this.sourceViewer.getTextWidget();
        } else {
            this.treeViewer.setInput((Object)this.getElement());
            this.showProperties();
            StackLayout layout = (StackLayout)this.viewerComposite.getLayout();
            layout.topControl = this.treeForm;
        }
        this.viewerComposite.layout();
    }

    protected abstract Expression getExpression();

    protected EClassifier getContextClassifier() {
        return null;
    }

    protected Map<String, EClassifier> getContextInformation() {
        return BoundUtil.getBoundObjects((EObject)this.getElement());
    }

    private void showProperties() {
        StackLayout properties = (StackLayout)this.treePropertiesComposite.getLayout();
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Composite control = this.emptyPC;
        if (selection.size() == 1) {
            Object selected = selection.getFirstElement();
            if (selected instanceof LiteralExpression) {
                LiteralExpression le = (LiteralExpression)selected;
                String value = le.getValue();
                this.literalValueText.setText(value == null ? "" : value);
                control = this.literalPC;
            } else if (selected instanceof ComparisonExpression) {
                ComparisonExpression ce = (ComparisonExpression)selected;
                this.comparisonOperatorCombo.select(ce.getOperator().ordinal());
                control = this.comparisonPC;
            } else if (selected instanceof ArithmeticExpression) {
                ArithmeticExpression ae = (ArithmeticExpression)selected;
                this.arithmeticOperatorCombo.select(ae.getOperator().ordinal());
                control = this.arithmeticPC;
            } else if (selected instanceof LogicalExpression) {
                LogicalExpression le = (LogicalExpression)selected;
                this.logicOperatorCombo.select(le.getOperator().ordinal());
                control = this.logicPC;
            } else if (selected instanceof ObjectVariableExpression) {
                ObjectVariableExpression ove = (ObjectVariableExpression)selected;
                String[] items = this.getObjectVariableItems();
                int index = this.getObjectVariableIndex(ove.getObject());
                this.oveVariableCombo.setItems(items);
                this.oveVariableCombo.select(index);
                control = this.ovePC;
            } else if (selected instanceof PrimitiveVariableExpression) {
                PrimitiveVariableExpression ove = (PrimitiveVariableExpression)selected;
                String[] items = this.getPrimitiveVariableItems();
                int index = this.getPrimitiveVariableIndex(ove.getPrimitiveVariable());
                this.pveVariableCombo.setItems(items);
                this.pveVariableCombo.select(index);
                control = this.pvePC;
            } else if (selected instanceof AttributeValueExpression) {
                AttributeValueExpression ave = (AttributeValueExpression)selected;
                String[] items = this.getObjectVariableItems();
                int index = this.getObjectVariableIndex(ave.getObject());
                this.attributesObjectCombo.setItems(items);
                this.attributesObjectCombo.select(index);
                items = this.getAttributeItems(ave.getObject());
                index = this.getAttributeIndex(ave.getAttribute());
                this.attributesCombo.setItems(items);
                this.attributesCombo.select(index);
                control = this.attributePC;
            }
        }
        properties.topControl = control;
        this.treePropertiesComposite.layout();
    }

    private String[] getObjectVariableItems() {
        this.objectVariables.clear();
        List variables = BoundUtil.getAllObjectVariables((Activity)ActivityUtil.getActivity((Object)this.getElement()));
        for (ObjectVariable variable : variables) {
            String key = variable.getName();
            if (key == null) {
                key = "";
            }
            this.objectVariables.put(key, variable);
        }
        return this.objectVariables.keySet().toArray(new String[this.objectVariables.keySet().size()]);
    }

    private int getObjectVariableIndex(ObjectVariable variable) {
        int index = 0;
        for (ObjectVariable check : this.objectVariables.values()) {
            if (check.equals(variable)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private String[] getPrimitiveVariableItems() {
        this.primitiveVariables.clear();
        List variables = BoundUtil.getAllPrimitiveVariables((Activity)ActivityUtil.getActivity((Object)this.getElement()));
        for (PrimitiveVariable variable : variables) {
            String key = variable.getName();
            if (key == null) {
                key = "";
            }
            this.primitiveVariables.put(key, variable);
        }
        return this.primitiveVariables.keySet().toArray(new String[this.primitiveVariables.keySet().size()]);
    }

    private int getPrimitiveVariableIndex(PrimitiveVariable variable) {
        int index = 0;
        for (PrimitiveVariable check : this.primitiveVariables.values()) {
            if (check.equals(variable)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private String[] getAttributeItems(ObjectVariable variable) {
        this.attributes.clear();
        if (variable != null && variable.getClassifier() != null) {
            for (EAttribute attribute : variable.getClassifier().getEAllAttributes()) {
                String key = attribute.getName();
                this.attributes.put(key, attribute);
            }
            return this.attributes.keySet().toArray(new String[this.attributes.keySet().size()]);
        }
        return new String[0];
    }

    private int getAttributeIndex(EAttribute attribute) {
        int index = 0;
        for (EAttribute check : this.attributes.values()) {
            if (check.equals(attribute)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void changeProperty(final EStructuralFeature feature, final Object value) {
        Object selected;
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.size() == 1 && (selected = selection.getFirstElement()) instanceof EObject) {
            RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)this.getEditingDomain()){

                protected void doExecute() {
                    ((EObject)selected).eSet(feature, value);
                }
            };
            this.execute((Command)command);
            this.refreshExpression();
            this.fillMenu();
            this.treeViewer.refresh();
            this.treeViewer.expandAll();
        }
    }

    private void refreshExpression() {
        RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)this.getEditingDomain()){

            protected void doExecute() {
                Expression expression = AbstractExtendedExpressionSection.this.getExpression();
                AbstractExtendedExpressionSection.this.setExpression(null);
                AbstractExtendedExpressionSection.this.setExpression(expression);
            }
        };
        this.execute((Command)command);
    }

    private void fillMenu() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            Menu menu = new Menu(this.treeViewer.getControl());
            if (element instanceof BinaryExpression) {
                EReference feature;
                String prefix;
                BinaryExpression be = (BinaryExpression)element;
                if (be.getLeftExpression() == null) {
                    prefix = "Left";
                    feature = CommonExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT_EXPRESSION;
                    this.createMenuItems(menu, (EStructuralFeature)feature, prefix);
                }
                if (be.getRightExpression() == null) {
                    prefix = "Right";
                    feature = CommonExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT_EXPRESSION;
                    this.createMenuItems(menu, (EStructuralFeature)feature, prefix);
                }
            } else if (element instanceof UnaryExpression) {
                EReference feature = CommonExpressionsPackage.Literals.UNARY_EXPRESSION__ENCLOSED_EXPRESSION;
                this.createMenuItems(menu, (EStructuralFeature)feature, null);
            }
            if (menu.getItemCount() > 0) {
                new MenuItem(menu, 2, 0);
            }
            MenuItem removeItem = new MenuItem(menu, 8, 0);
            removeItem.setText("Remove");
            removeItem.setImage(CoreImages.get((String)"icons/remove.png"));
            removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractExtendedExpressionSection.this.remove();
                }
            });
            this.treeViewer.getControl().setMenu(menu);
        } else {
            this.treeViewer.getControl().setMenu(null);
        }
    }

    private void createMenuItems(Menu menu, EStructuralFeature feature, String prefix) {
        this.createMenuItem(menu, feature, (EObject)CommonExpressionsFactory.eINSTANCE.createArithmeticExpression(), prefix);
        this.createMenuItem(menu, feature, (EObject)CommonExpressionsFactory.eINSTANCE.createLogicalExpression(), prefix);
        this.createMenuItem(menu, feature, (EObject)CommonExpressionsFactory.eINSTANCE.createComparisonExpression(), prefix);
        this.createMenuItem(menu, feature, (EObject)CommonExpressionsFactory.eINSTANCE.createUnaryExpression(), prefix);
        this.createMenuItem(menu, feature, (EObject)CommonExpressionsFactory.eINSTANCE.createLiteralExpression(), prefix);
        new MenuItem(menu, 2);
        this.createMenuItem(menu, feature, (EObject)CallsExpressionsFactory.eINSTANCE.createMethodCallExpression(), prefix);
        this.createMenuItem(menu, feature, (EObject)CallsExpressionsFactory.eINSTANCE.createParameterExpression(), prefix);
        new MenuItem(menu, 2);
        this.createMenuItem(menu, feature, (EObject)PatternsExpressionsFactory.eINSTANCE.createAttributeValueExpression(), prefix);
        this.createMenuItem(menu, feature, (EObject)PatternsExpressionsFactory.eINSTANCE.createCollectionSizeExpression(), prefix);
        this.createMenuItem(menu, feature, (EObject)PatternsExpressionsFactory.eINSTANCE.createObjectVariableExpression(), prefix);
        this.createMenuItem(menu, feature, (EObject)PatternsExpressionsFactory.eINSTANCE.createPrimitiveVariableExpression(), prefix);
        new MenuItem(menu, 2);
        this.createMenuItem(menu, feature, (EObject)ActivitiesExpressionsFactory.eINSTANCE.createExceptionVariableExpression(), prefix);
    }

    private void createMenuItem(Menu menu, final EStructuralFeature feature, final EObject element, String prefix) {
        String text = this.getEClassName(element);
        if (prefix != null) {
            text = String.valueOf(prefix) + ':' + ' ' + text;
        }
        MenuItem item = new MenuItem(menu, 0);
        item.setImage(this.labelProvider.getImage((Object)element));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractExtendedExpressionSection.this.changeProperty(feature, element);
            }
        });
        item.setText(text);
    }

    private String getEClassName(EObject element) {
        StringBuilder builder = new StringBuilder();
        String value = element.eClass().getName();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                builder.append(' ');
            }
            builder.append(c);
            ++i;
        }
        return builder.toString();
    }
}

