/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityEdge;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.activities.InitialNode;
import org.storydriven.storydiagrams.activities.OperationExtension;

public final class ActivityUtil {
    private ActivityUtil() {
    }

    public static int compare(ActivityNode a, ActivityNode b) {
        int test = ActivityUtil.check(a, b);
        if (test != 0) {
            return test;
        }
        int sizeA = 0;
        sizeA += a.getIncomings().size();
        int sizeB = 0;
        sizeB += b.getIncomings().size();
        return (sizeA += a.getOutgoings().size()) - (sizeB += b.getOutgoings().size());
    }

    private static int check(ActivityNode a, ActivityNode b) {
        for (ActivityEdge out : a.getOutgoings()) {
            if (!b.equals(out.getTarget())) continue;
            return -1;
        }
        for (ActivityEdge out : b.getOutgoings()) {
            if (!a.equals(out.getSource())) continue;
            return 1;
        }
        return 0;
    }

    public static InitialNode getInitialNode(Activity activity) {
        for (ActivityNode node : activity.getOwnedActivityNodes()) {
            if (!(node instanceof InitialNode)) continue;
            return (InitialNode)node;
        }
        return null;
    }

    public static EOperation getEOperation(Activity activity) {
        OperationExtension operationExtension;
        if (activity != null && (operationExtension = activity.getOwningOperation()) != null) {
            return operationExtension.getOperation();
        }
        return null;
    }

    public static Activity getActivity(Object element) {
        if (element instanceof Activity) {
            return (Activity)element;
        }
        if (element instanceof EObject) {
            EObject parent = ((EObject)element).eContainer();
            while (parent != null) {
                Activity result = ActivityUtil.getActivity(parent);
                if (result != null) {
                    return result;
                }
                parent = parent.eContainer();
            }
        }
        return null;
    }

    public static boolean isIndependent(Activity element) {
        return element.eContainer() == null;
    }
}

