/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.patterns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BindingState implements Enumerator
{
    UNBOUND(0, "UNBOUND", "UNBOUND"),
    BOUND(1, "BOUND", "BOUND"),
    MAYBE_BOUND(2, "MAYBE_BOUND", "MAYBE_BOUND");

    public static final int UNBOUND_VALUE = 0;
    public static final int BOUND_VALUE = 1;
    public static final int MAYBE_BOUND_VALUE = 2;
    private static final BindingState[] VALUES_ARRAY;
    public static final List<BindingState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BindingState[]{UNBOUND, BOUND, MAYBE_BOUND};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BindingState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindingState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindingState get(int value) {
        switch (value) {
            case 0: {
                return UNBOUND;
            }
            case 1: {
                return BOUND;
            }
            case 2: {
                return MAYBE_BOUND;
            }
        }
        return null;
    }

    private BindingState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

