/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import tools.descartes.dlim.DlimFactory;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.Polynomial;
import tools.descartes.dlim.PolynomialFactor;
import tools.descartes.dlim.provider.FunctionItemProvider;

public class PolynomialItemProvider
extends FunctionItemProvider {
    public PolynomialItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(DlimPackage.Literals.POLYNOMIAL__FACTORS);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Polynomial"));
    }

    @Override
    public String getText(Object object) {
        String label = this.newLabelText((Polynomial)object);
        return label == null || label.length() == 0 ? this.getString("_UI_Polynomial_type") : String.valueOf(this.getString("_UI_Polynomial_type")) + " " + label;
    }

    private String newLabelText(Polynomial polynom) {
        if (polynom.getFactors().isEmpty()) {
            return "empty";
        }
        String labelText = "";
        int index = polynom.getFactors().size() - 1;
        for (PolynomialFactor f : polynom.getFactors()) {
            String offsetX = "(x + " + f.getOffset() + ")";
            if (f.getOffset() == 0.0) {
                offsetX = "x";
            }
            String order = " * " + offsetX + "^" + index;
            if (index == 0) {
                order = "";
            } else if (index == 1) {
                order = " * " + offsetX;
            }
            labelText = String.valueOf(labelText) + " + " + f.getFactor() + order;
            --index;
        }
        return labelText.substring(3);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Polynomial.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        switch (notification.getFeatureID(PolynomialFactor.class)) {
            case 0: 
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(DlimPackage.Literals.POLYNOMIAL__FACTORS, DlimFactory.eINSTANCE.createPolynomialFactor()));
    }
}

