/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TimeStampGeneratorParametersDialog
extends TitleAreaDialog {
    private Text decimalPlacesText;
    private Text stepText;
    private Text rndSeedText;
    private Text stretchText;
    private Text arDevisorText;
    private Button equalRadio;
    private Button uniformRadio;
    private Button noStampsRadio;
    private String samplingMode = "dlim:equal";
    private int decimalPlaces = 3;
    private int rndSeed = 5;
    private double step = 1.0;
    private double stretch = 1.0;
    private double arDevisor = 1.0;
    private boolean canceled = false;
    private String fileString;

    public TimeStampGeneratorParametersDialog(String fileString, Shell parentShell) {
        super(parentShell);
        this.fileString = fileString;
    }

    private void setDefaultValues() {
        this.samplingMode = "dlim:equal";
        this.decimalPlaces = 3;
        this.rndSeed = 5;
        this.step = 1.0;
        this.stretch = 1.0;
        this.arDevisor = 1.0;
        this.canceled = false;
    }

    public void create() {
        super.create();
        this.setTitle("Arrival Rate and Request Time Stamp Generation Parameters");
        this.setMessage("For Model: " + this.fileString, 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        Composite columnContainer = new Composite(dialogContainer, 0);
        columnContainer.setLayout((Layout)new FillLayout(512));
        this.createSamplingModeParameterField(columnContainer);
        this.createDecimalPlaceParameterField(columnContainer);
        this.createStepParameterField(columnContainer);
        this.createRndSeedParameterField(columnContainer);
        Label delimiterLabel = new Label(columnContainer, 0);
        delimiterLabel.setText("Time Stamp Modifiers");
        delimiterLabel.setAlignment(0x1000000);
        this.createStretchParameterField(columnContainer);
        this.createArDevisorParameterField(columnContainer);
        return dialogContainer;
    }

    private void createSamplingModeParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)gridLayout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Sampling Method:        ");
        GridData parameterLabelData = new GridData();
        parameterLabelData.horizontalAlignment = 1;
        parameterLabelData.verticalAlignment = 1;
        parameterLabelData.grabExcessHorizontalSpace = true;
        parameterFieldLabel.setLayoutData((Object)parameterLabelData);
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.grabExcessVerticalSpace = false;
        parameterFieldData.verticalAlignment = 1;
        Composite radioContainer = new Composite(gridContainer, 0);
        radioContainer.setLayoutData((Object)parameterFieldData);
        radioContainer.setLayout((Layout)new FillLayout(512));
        this.noStampsRadio = new Button(radioContainer, 16);
        this.noStampsRadio.setText("Do not generate Time Stamps");
        this.noStampsRadio.setSelection(false);
        this.equalRadio = new Button(radioContainer, 16);
        this.equalRadio.setText("Equal Distance");
        this.equalRadio.setSelection(true);
        this.uniformRadio = new Button(radioContainer, 16);
        this.uniformRadio.setText("Uniform Distribution");
        this.uniformRadio.setSelection(false);
    }

    private void createDecimalPlaceParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Maximum Decimal Places: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 16;
        this.decimalPlacesText = new Text(gridContainer, 2048);
        this.decimalPlacesText.setText("3");
        this.decimalPlacesText.setLayoutData((Object)parameterFieldData);
    }

    private void createRndSeedParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Random Generator Seed: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 16;
        this.rndSeedText = new Text(gridContainer, 2048);
        this.rndSeedText.setText("5");
        this.rndSeedText.setLayoutData((Object)parameterFieldData);
    }

    private void createStepParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Sampling Interval Width: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 20;
        this.stepText = new Text(gridContainer, 2048);
        this.stepText.setText("1.0");
        this.stepText.setLayoutData((Object)parameterFieldData);
    }

    private void createStretchParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Stretch Model Times by: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 20;
        this.stretchText = new Text(gridContainer, 2048);
        this.stretchText.setText("1.0");
        this.stretchText.setLayoutData((Object)parameterFieldData);
    }

    private void createArDevisorParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Divide Model Arrival Rates by: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 24;
        this.arDevisorText = new Text(gridContainer, 2048);
        this.arDevisorText.setText("1.0");
        this.arDevisorText.setLayoutData((Object)parameterFieldData);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Request Time Stamp Generation Parameters");
    }

    protected void cancelPressed() {
        this.setDefaultValues();
        this.canceled = true;
        super.cancelPressed();
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    protected void okPressed() {
        boolean error = false;
        try {
            this.decimalPlaces = Integer.parseInt(this.decimalPlacesText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Decimal Places must be an Integer.", 3);
            error = true;
        }
        try {
            this.step = Double.parseDouble(this.stepText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Sampling Interval Width must be a number.", 3);
            error = true;
        }
        try {
            this.rndSeed = Integer.parseInt(this.rndSeedText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Random Seed must be an Integer.", 3);
            error = true;
        }
        try {
            this.stretch = Double.parseDouble(this.stretchText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Time stretch factor must be a number.", 3);
            error = true;
        }
        try {
            this.arDevisor = Double.parseDouble(this.arDevisorText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Arrival Rate Devisor must be a number.", 3);
            error = true;
        }
        if (this.arDevisor <= 0.0) {
            error = true;
            this.setMessage("Arrival Rate Devisor must greater than 0.", 3);
        }
        if (this.stretch <= 0.0) {
            error = true;
            this.setMessage("Time stretch factor must greater than 0.", 3);
        }
        if (this.step <= 0.0) {
            error = true;
            this.setMessage("Sampling Interval Width must greater than 0.", 3);
        }
        if (this.decimalPlaces <= 0) {
            error = true;
            this.setMessage("Decimal Places must greater than 0.", 3);
        }
        if (!error) {
            this.samplingMode = this.equalRadio.getSelection() ? "dlim:equal" : (this.uniformRadio.getSelection() ? "dlim:uniform" : "dlim:noTimeStamps");
            super.okPressed();
        }
    }

    public int getRndSeed() {
        return this.rndSeed;
    }

    public String getSamplingMode() {
        return this.samplingMode;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public double getStep() {
        return this.step;
    }

    public double getStretch() {
        return this.stretch;
    }

    public double getArDevisor() {
        return this.arDevisor;
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }
}

