/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.popup.actions;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.generator.DiffAnalyzer;
import tools.descartes.dlim.generator.ModelEvaluator;
import tools.descartes.dlim.generator.editor.dialogs.DiffResultsDialog;
import tools.descartes.dlim.generator.editor.dialogs.LaunchDiffDialog;
import tools.descartes.dlim.generator.editor.utils.ProjectManager;
import tools.descartes.dlim.generator.ui.utils.DlimFileUtils;
import tools.descartes.dlim.presentation.DlimEditorPlugin;
import tools.descartes.dlim.reader.ArrivalRateReader;

public class DiffRunnerAction
implements IObjectActionDelegate {
    private Shell shell;
    private ISelection currentSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        ProjectManager pManager = new ProjectManager(this.currentSelection);
        LaunchDiffDialog dialog = new LaunchDiffDialog(DlimFileUtils.getSelectionPath((ISelection)this.currentSelection), this.shell);
        dialog.open();
        if (!dialog.wasCanceled()) {
            ModelEvaluator evaluator = new ModelEvaluator((Sequence)DlimFileUtils.getRootEObject((ISelection)this.currentSelection), dialog.getRndSeed(), "dlim:evaluation");
            DiffAnalyzer analyzer = new DiffAnalyzer(evaluator, pManager.getProjectPath());
            try {
                List statisticalValues = analyzer.calculateDiff(ArrivalRateReader.readFileToList((String)dialog.getTxtFilePath(), (double)0.0), dialog.getOffset());
                if (statisticalValues.isEmpty()) {
                    MessageDialog.openError((Shell)this.shell, (String)"Error Calculating Difference.", (String)"Could not calculate difference.\nThis error is most likely caused by trying to compare a time stamp file with the model.\nKeep in mind that you can only compare the model with arrival rate files containing data points of the form \"<time stamp>,<arrival rate>[;]\"");
                }
                DiffResultsDialog resultsDialog = new DiffResultsDialog(this.shell, (Double)statisticalValues.get(0), (Double)statisticalValues.get(1), (Double)statisticalValues.get(2), (Double)statisticalValues.get(3), (Double)statisticalValues.get(4));
                resultsDialog.open();
            }
            catch (IOException e) {
                DlimEditorPlugin.getPlugin().log(new Status(2, "tools.descartes.dlim.presentation.DlimEditorPlugin", "Error reading trace.", (Throwable)e));
            }
        }
        pManager.refreshProject();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }
}

