/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator;

import com.dtw.FastDTW;
import com.timeseries.TimeSeries;
import com.timeseries.TimeSeriesPoint;
import com.util.DistanceFunction;
import com.util.EuclideanDistance;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import tools.descartes.dlim.generator.Activator;
import tools.descartes.dlim.generator.ArrivalRateTuple;
import tools.descartes.dlim.generator.ModelEvaluator;

public class DiffAnalyzer {
    private ModelEvaluator evaluator;
    private IPath projectPath;
    private TimeSeries fileTS;
    private TimeSeries modelTS;
    private ArrayList<Double> diffList;
    private ArrayList<Double> relativeDiffList;

    public DiffAnalyzer(ModelEvaluator evaluator, String projectPath) {
        this.evaluator = evaluator;
        this.projectPath = new Path(projectPath);
        this.diffList = new ArrayList();
        this.relativeDiffList = new ArrayList();
        this.fileTS = new TimeSeries(2);
        this.modelTS = new TimeSeries(2);
    }

    public List<Double> calculateDiff(List<ArrivalRateTuple> readArrivalRates, double offset) {
        try {
            double maxArrivalRate = 0.0;
            IPath diffFolderPath = this.projectPath.append("diffs");
            File diffFolder = diffFolderPath.toFile();
            if (!diffFolder.exists()) {
                diffFolder.mkdir();
            }
            IPath diffTxtPath = diffFolderPath.append(String.valueOf(this.evaluator.getName()) + "Diff.txt");
            PrintWriter diffWriter = new PrintWriter(diffTxtPath.toString(), "UTF-8");
            double diffSum = 0.0;
            double relativeDiffSum = 0.0;
            for (ArrivalRateTuple t : readArrivalRates) {
                double timeStamp = t.getTimeStamp();
                double readArrivalRate = t.getArrivalRate();
                double modelTimeStamp = timeStamp - offset;
                if (!(modelTimeStamp > 0.0) || !(modelTimeStamp < this.evaluator.getTerminatingDuration())) continue;
                double[] fileTSPoint = new double[]{modelTimeStamp, readArrivalRate};
                this.fileTS.addLast(modelTimeStamp, new TimeSeriesPoint(fileTSPoint));
                double functionArrivalRate = this.evaluator.getArrivalRateAtTime(modelTimeStamp);
                double[] modelTSPoint = new double[]{modelTimeStamp, functionArrivalRate};
                this.modelTS.addLast(modelTimeStamp, new TimeSeriesPoint(modelTSPoint));
                double diff = Math.abs(readArrivalRate - functionArrivalRate);
                diffWriter.println(String.valueOf(modelTimeStamp) + "," + diff + ";");
                this.diffList.add(diff);
                double relativeDiff = 0.0;
                if (readArrivalRate != 0.0) {
                    relativeDiff = diff / readArrivalRate;
                }
                this.relativeDiffList.add(relativeDiff);
                relativeDiffSum += relativeDiff;
                diffSum += diff;
                if (!(readArrivalRate > maxArrivalRate)) continue;
                maxArrivalRate = readArrivalRate;
            }
            diffWriter.close();
            if (this.diffList.size() == 0) {
                Activator.getInstance().log((IStatus)new Status(2, "tools.descartes.dlim.generator", "file has an incorrect format. Only files with the correct Arrival Rate format can be read."));
            }
            Collections.sort(this.diffList);
            Collections.sort(this.relativeDiffList);
            double dtwDist = FastDTW.getWarpInfoBetween((TimeSeries)this.fileTS, (TimeSeries)this.modelTS, (int)10, (DistanceFunction)new EuclideanDistance()).getDistance();
            dtwDist /= (double)this.diffList.size();
            dtwDist /= maxArrivalRate;
            double mean = diffSum / (double)this.diffList.size();
            double median = this.diffList.get(this.diffList.size() / 2);
            LinkedList<Double> statisticalValues = new LinkedList<Double>();
            statisticalValues.add(mean);
            statisticalValues.add(median);
            statisticalValues.add(dtwDist);
            statisticalValues.add(relativeDiffSum / (double)this.relativeDiffList.size());
            statisticalValues.add(this.relativeDiffList.get(this.relativeDiffList.size() / 2));
            return statisticalValues;
        }
        catch (FileNotFoundException e) {
            Activator.getInstance().log((IStatus)new Status(1, "tools.descartes.dlim.generator", "Output Diff File not found.", (Throwable)e));
        }
        catch (UnsupportedEncodingException e) {
            Activator.getInstance().log((IStatus)new Status(1, "tools.descartes.dlim.generator", "Diff encoding unsupported.", (Throwable)e));
        }
        catch (IndexOutOfBoundsException e) {
            new Status(1, "tools.descartes.dlim.generator", "Could not Calculate Difference. Wrong file Type?");
        }
        return new LinkedList<Double>();
    }
}

