/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import tools.descartes.dlim.AbsoluteSin;
import tools.descartes.dlim.AbsoluteValueFunction;
import tools.descartes.dlim.ArrivalRatesFromFile;
import tools.descartes.dlim.Burst;
import tools.descartes.dlim.ClockType;
import tools.descartes.dlim.Combinator;
import tools.descartes.dlim.Constant;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.DlimPlugin;
import tools.descartes.dlim.ExponentialIncreaseAndDecline;
import tools.descartes.dlim.ExponentialIncreaseLogarithmicDecline;
import tools.descartes.dlim.ExponentialTrend;
import tools.descartes.dlim.Function;
import tools.descartes.dlim.LinearIncreaseAndDecline;
import tools.descartes.dlim.LinearTrend;
import tools.descartes.dlim.LogarithmicTrend;
import tools.descartes.dlim.Noise;
import tools.descartes.dlim.NormalNoise;
import tools.descartes.dlim.Operator;
import tools.descartes.dlim.Polynomial;
import tools.descartes.dlim.PolynomialFactor;
import tools.descartes.dlim.ReferenceClockObject;
import tools.descartes.dlim.Seasonal;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.Sin;
import tools.descartes.dlim.SinTrend;
import tools.descartes.dlim.TimeDependentFunctionContainer;
import tools.descartes.dlim.Trend;
import tools.descartes.dlim.UniformNoise;
import tools.descartes.dlim.UnivariateFunction;

public class DlimValidator
extends EObjectValidator {
    public static final DlimValidator INSTANCE = new DlimValidator();
    public static final String DIAGNOSTIC_SOURCE = "tools.descartes.dlim";
    public static final int SEQUENCE__DURATION_DEFINED = 1;
    public static final int TIME_DEPENDENT_FUNCTION_CONTAINER__DURATION_GREATER_ZERO = 2;
    public static final int TIME_DEPENDENT_FUNCTION_CONTAINER__REFERENCE_CLOCK_IN_TREE_NODE = 3;
    public static final int BURST__PEAK_TIME_GREATER_ZERO = 4;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 4;
    protected static final int DIAGNOSTIC_CODE_COUNT = 4;

    protected EPackage getEPackage() {
        return DlimPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateSequence((Sequence)value, diagnostics, context);
            }
            case 1: {
                return this.validateCombinator((Combinator)value, diagnostics, context);
            }
            case 2: {
                return this.validateTimeDependentFunctionContainer((TimeDependentFunctionContainer)value, diagnostics, context);
            }
            case 3: {
                return this.validateFunction((Function)value, diagnostics, context);
            }
            case 4: {
                return this.validateSeasonal((Seasonal)value, diagnostics, context);
            }
            case 5: {
                return this.validateNoise((Noise)value, diagnostics, context);
            }
            case 6: {
                return this.validateUniformNoise((UniformNoise)value, diagnostics, context);
            }
            case 7: {
                return this.validateNormalNoise((NormalNoise)value, diagnostics, context);
            }
            case 8: {
                return this.validateBurst((Burst)value, diagnostics, context);
            }
            case 9: {
                return this.validateTrend((Trend)value, diagnostics, context);
            }
            case 10: {
                return this.validateConstant((Constant)value, diagnostics, context);
            }
            case 11: {
                return this.validateSin((Sin)value, diagnostics, context);
            }
            case 12: {
                return this.validateExponentialIncreaseAndDecline((ExponentialIncreaseAndDecline)value, diagnostics, context);
            }
            case 13: {
                return this.validateExponentialIncreaseLogarithmicDecline((ExponentialIncreaseLogarithmicDecline)value, diagnostics, context);
            }
            case 14: {
                return this.validateLinearIncreaseAndDecline((LinearIncreaseAndDecline)value, diagnostics, context);
            }
            case 15: {
                return this.validateAbsoluteSin((AbsoluteSin)value, diagnostics, context);
            }
            case 16: {
                return this.validateLinearTrend((LinearTrend)value, diagnostics, context);
            }
            case 17: {
                return this.validateExponentialTrend((ExponentialTrend)value, diagnostics, context);
            }
            case 18: {
                return this.validateLogarithmicTrend((LogarithmicTrend)value, diagnostics, context);
            }
            case 19: {
                return this.validateSinTrend((SinTrend)value, diagnostics, context);
            }
            case 20: {
                return this.validateReferenceClockObject((ReferenceClockObject)value, diagnostics, context);
            }
            case 21: {
                return this.validateArrivalRatesFromFile((ArrivalRatesFromFile)value, diagnostics, context);
            }
            case 22: {
                return this.validateAbsoluteValueFunction((AbsoluteValueFunction)value, diagnostics, context);
            }
            case 23: {
                return this.validateUnivariateFunction((UnivariateFunction)value, diagnostics, context);
            }
            case 24: {
                return this.validatePolynomial((Polynomial)value, diagnostics, context);
            }
            case 25: {
                return this.validatePolynomialFactor((PolynomialFactor)value, diagnostics, context);
            }
            case 26: {
                return this.validateClockType((ClockType)((Object)value), diagnostics, context);
            }
            case 27: {
                return this.validateOperator((Operator)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateSequence(Sequence sequence, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(sequence, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(sequence, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(sequence, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(sequence, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(sequence, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(sequence, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(sequence, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(sequence, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(sequence, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSequence_durationDefined(sequence, diagnostics, context);
        }
        return result;
    }

    public boolean validateSequence_durationDefined(Sequence sequence, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return sequence.durationDefined(diagnostics, context);
    }

    public boolean validateCombinator(Combinator combinator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(combinator, diagnostics, context);
    }

    public boolean validateTimeDependentFunctionContainer(TimeDependentFunctionContainer timeDependentFunctionContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(timeDependentFunctionContainer, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(timeDependentFunctionContainer, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(timeDependentFunctionContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(timeDependentFunctionContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(timeDependentFunctionContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(timeDependentFunctionContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(timeDependentFunctionContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(timeDependentFunctionContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(timeDependentFunctionContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTimeDependentFunctionContainer_durationGreaterZero(timeDependentFunctionContainer, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTimeDependentFunctionContainer_referenceClockInTreeNode(timeDependentFunctionContainer, diagnostics, context);
        }
        return result;
    }

    public boolean validateTimeDependentFunctionContainer_durationGreaterZero(TimeDependentFunctionContainer timeDependentFunctionContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return timeDependentFunctionContainer.durationGreaterZero(diagnostics, context);
    }

    public boolean validateTimeDependentFunctionContainer_referenceClockInTreeNode(TimeDependentFunctionContainer timeDependentFunctionContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return timeDependentFunctionContainer.referenceClockInTreeNode(diagnostics, context);
    }

    public boolean validateFunction(Function function, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(function, diagnostics, context);
    }

    public boolean validateSeasonal(Seasonal seasonal, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(seasonal, diagnostics, context);
    }

    public boolean validateNoise(Noise noise, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(noise, diagnostics, context);
    }

    public boolean validateUniformNoise(UniformNoise uniformNoise, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(uniformNoise, diagnostics, context);
    }

    public boolean validateNormalNoise(NormalNoise normalNoise, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(normalNoise, diagnostics, context);
    }

    public boolean validateBurst(Burst burst, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(burst, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(burst, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(burst, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(burst, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(burst, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(burst, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(burst, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(burst, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(burst, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBurst_peakTimeGreaterZero(burst, diagnostics, context);
        }
        return result;
    }

    public boolean validateBurst_peakTimeGreaterZero(Burst burst, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return burst.peakTimeGreaterZero(diagnostics, context);
    }

    public boolean validateTrend(Trend trend, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(trend, diagnostics, context);
    }

    public boolean validateConstant(Constant constant, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(constant, diagnostics, context);
    }

    public boolean validateSin(Sin sin, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(sin, diagnostics, context);
    }

    public boolean validateExponentialIncreaseAndDecline(ExponentialIncreaseAndDecline exponentialIncreaseAndDecline, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(exponentialIncreaseAndDecline, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(exponentialIncreaseAndDecline, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(exponentialIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(exponentialIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(exponentialIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(exponentialIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(exponentialIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(exponentialIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(exponentialIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBurst_peakTimeGreaterZero(exponentialIncreaseAndDecline, diagnostics, context);
        }
        return result;
    }

    public boolean validateExponentialIncreaseLogarithmicDecline(ExponentialIncreaseLogarithmicDecline exponentialIncreaseLogarithmicDecline, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(exponentialIncreaseLogarithmicDecline, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(exponentialIncreaseLogarithmicDecline, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(exponentialIncreaseLogarithmicDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(exponentialIncreaseLogarithmicDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(exponentialIncreaseLogarithmicDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(exponentialIncreaseLogarithmicDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(exponentialIncreaseLogarithmicDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(exponentialIncreaseLogarithmicDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(exponentialIncreaseLogarithmicDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBurst_peakTimeGreaterZero(exponentialIncreaseLogarithmicDecline, diagnostics, context);
        }
        return result;
    }

    public boolean validateLinearIncreaseAndDecline(LinearIncreaseAndDecline linearIncreaseAndDecline, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(linearIncreaseAndDecline, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(linearIncreaseAndDecline, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(linearIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(linearIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(linearIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(linearIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(linearIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(linearIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(linearIncreaseAndDecline, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBurst_peakTimeGreaterZero(linearIncreaseAndDecline, diagnostics, context);
        }
        return result;
    }

    public boolean validateAbsoluteSin(AbsoluteSin absoluteSin, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(absoluteSin, diagnostics, context);
    }

    public boolean validateLinearTrend(LinearTrend linearTrend, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(linearTrend, diagnostics, context);
    }

    public boolean validateExponentialTrend(ExponentialTrend exponentialTrend, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(exponentialTrend, diagnostics, context);
    }

    public boolean validateLogarithmicTrend(LogarithmicTrend logarithmicTrend, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(logarithmicTrend, diagnostics, context);
    }

    public boolean validateSinTrend(SinTrend sinTrend, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(sinTrend, diagnostics, context);
    }

    public boolean validateReferenceClockObject(ReferenceClockObject referenceClockObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(referenceClockObject, diagnostics, context);
    }

    public boolean validateArrivalRatesFromFile(ArrivalRatesFromFile arrivalRatesFromFile, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(arrivalRatesFromFile, diagnostics, context);
    }

    public boolean validateAbsoluteValueFunction(AbsoluteValueFunction absoluteValueFunction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(absoluteValueFunction, diagnostics, context);
    }

    public boolean validateUnivariateFunction(UnivariateFunction univariateFunction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(univariateFunction, diagnostics, context);
    }

    public boolean validatePolynomial(Polynomial polynomial, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(polynomial, diagnostics, context);
    }

    public boolean validatePolynomialFactor(PolynomialFactor polynomialFactor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(polynomialFactor, diagnostics, context);
    }

    public boolean validateClockType(ClockType clockType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateOperator(Operator operator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return DlimPlugin.INSTANCE;
    }
}

