/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.commons.jdt.resolve;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import tools.mdsd.jamopp.commons.jdt.JDTJavaClassifier;
import tools.mdsd.jamopp.commons.jdt.JdtPackage;
import tools.mdsd.jamopp.commons.jdt.resolve.ClassifierVisitor;

public class JDTClassifierResolver {
    public IJavaProject getJavaProject(URI uri) {
        IProject project = JDTClassifierResolver.getProject(uri);
        IJavaProject javaProject = null;
        if (project != null) {
            javaProject = JDTClassifierResolver.getJavaProject(project);
        }
        return javaProject;
    }

    private static boolean isJavaProject(IProject project) {
        boolean result = false;
        if (project != null) {
            try {
                result = project.isNatureEnabled("org.eclipse.jdt.core.javanature");
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return result;
    }

    private static IProject getProject(URI uri) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (uri.isPlatformResource() && uri.segmentCount() > 2) {
            String segment = uri.segment(1);
            String decoded = URI.decode((String)segment);
            return root.getProject(decoded);
        }
        throw new IllegalArgumentException("Can't handle URIs that do not reference platform resources: " + uri);
    }

    private static IJavaProject getJavaProject(IProject project) {
        IJavaProject javaProject = null;
        if (JDTClassifierResolver.isJavaProject(project)) {
            javaProject = JavaCore.create((IProject)project);
        }
        return javaProject;
    }

    public List<JDTJavaClassifier> getAllClassifiersInClassPath(IJavaProject project) {
        return this.getAllClassifiersForPackageInClassPath(null, project);
    }

    public List<JDTJavaClassifier> getAllClassifiersForPackageInClassPath(String packageName, IJavaProject project) {
        List<JDTJavaClassifier> classes = new ArrayList<JDTJavaClassifier>();
        try {
            SearchEngine searchEngine = new SearchEngine();
            ClassifierVisitor visitor = new ClassifierVisitor(project);
            char[][] packages = null;
            if (packageName != null) {
                packages = new char[][]{packageName.toCharArray()};
            }
            IJavaProject[] projects = new IJavaProject[]{project};
            IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])projects);
            boolean waitingPolicy = true;
            searchEngine.searchAllTypeNames((char[][])packages, null, searchScope, (TypeNameRequestor)visitor, 1, null);
            classes = visitor.getClassifiersInClasspath();
        }
        catch (JavaModelException e) {
            JDTClassifierResolver.logWarning("Search for Java classifiers failed.", e);
        }
        return classes;
    }

    private static void logWarning(String message, JavaModelException exception) {
        String pluginName = JdtPackage.class.getPackage().getName();
        Status status = new Status(2, pluginName, message, (Throwable)exception);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }
}

