/**
 * Copyright (c) 2006-2012
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *  
 */
package tools.mdsd.jamopp.commons.layout;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see tools.mdsd.jamopp.commons.layout.LayoutPackage
 * @generated
 */
public interface LayoutFactory extends EFactory
{
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	LayoutFactory eINSTANCE = tools.mdsd.jamopp.commons.layout.impl.LayoutFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Reference Layout Information</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Reference Layout Information</em>'.
	 * @generated
	 */
	ReferenceLayoutInformation createReferenceLayoutInformation();

	/**
	 * Returns a new object of class '<em>Attribute Layout Information</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Attribute Layout Information</em>'.
	 * @generated
	 */
	AttributeLayoutInformation createAttributeLayoutInformation();

	/**
	 * Returns a new object of class '<em>Keyword Layout Information</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Keyword Layout Information</em>'.
	 * @generated
	 */
	KeywordLayoutInformation createKeywordLayoutInformation();

	/**
	 * Returns a new object of class '<em>Minimal Layout Information</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Minimal Layout Information</em>'.
	 * @generated
	 */
	MinimalLayoutInformation createMinimalLayoutInformation();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	LayoutPackage getLayoutPackage();

} //LayoutFactory
