/**
 * Copyright (c) 2006-2012
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *  
 */
package tools.mdsd.jamopp.commons.layout.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import tools.mdsd.jamopp.commons.layout.AttributeLayoutInformation;
import tools.mdsd.jamopp.commons.layout.KeywordLayoutInformation;
import tools.mdsd.jamopp.commons.layout.LayoutFactory;
import tools.mdsd.jamopp.commons.layout.LayoutInformation;
import tools.mdsd.jamopp.commons.layout.LayoutPackage;
import tools.mdsd.jamopp.commons.layout.MinimalLayoutInformation;
import tools.mdsd.jamopp.commons.layout.ReferenceLayoutInformation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class LayoutPackageImpl extends EPackageImpl implements LayoutPackage
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass layoutInformationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass referenceLayoutInformationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass attributeLayoutInformationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass keywordLayoutInformationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass minimalLayoutInformationEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see tools.mdsd.jamopp.commons.layout.LayoutPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private LayoutPackageImpl()
	{
		super(eNS_URI, LayoutFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link LayoutPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static LayoutPackage init()
	{
		if (isInited) return (LayoutPackage)EPackage.Registry.INSTANCE.getEPackage(LayoutPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredLayoutPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		LayoutPackageImpl theLayoutPackage = registeredLayoutPackage instanceof LayoutPackageImpl ? (LayoutPackageImpl)registeredLayoutPackage : new LayoutPackageImpl();

		isInited = true;

		// Create package meta-data objects
		theLayoutPackage.createPackageContents();

		// Initialize created meta-data
		theLayoutPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theLayoutPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(LayoutPackage.eNS_URI, theLayoutPackage);
		return theLayoutPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getLayoutInformation()
	{
		return layoutInformationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getLayoutInformation_StartOffset()
	{
		return (EAttribute)layoutInformationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getLayoutInformation_HiddenTokenText()
	{
		return (EAttribute)layoutInformationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getLayoutInformation_VisibleTokenText()
	{
		return (EAttribute)layoutInformationEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getLayoutInformation_SyntaxElementID()
	{
		return (EAttribute)layoutInformationEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getReferenceLayoutInformation()
	{
		return referenceLayoutInformationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getReferenceLayoutInformation_Object()
	{
		return (EReference)referenceLayoutInformationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAttributeLayoutInformation()
	{
		return attributeLayoutInformationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getKeywordLayoutInformation()
	{
		return keywordLayoutInformationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMinimalLayoutInformation()
	{
		return minimalLayoutInformationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMinimalLayoutInformation_Length()
	{
		return (EAttribute)minimalLayoutInformationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMinimalLayoutInformation_RootLayout()
	{
		return (EReference)minimalLayoutInformationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LayoutFactory getLayoutFactory()
	{
		return (LayoutFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents()
	{
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		layoutInformationEClass = createEClass(LAYOUT_INFORMATION);
		createEAttribute(layoutInformationEClass, LAYOUT_INFORMATION__START_OFFSET);
		createEAttribute(layoutInformationEClass, LAYOUT_INFORMATION__HIDDEN_TOKEN_TEXT);
		createEAttribute(layoutInformationEClass, LAYOUT_INFORMATION__VISIBLE_TOKEN_TEXT);
		createEAttribute(layoutInformationEClass, LAYOUT_INFORMATION__SYNTAX_ELEMENT_ID);

		referenceLayoutInformationEClass = createEClass(REFERENCE_LAYOUT_INFORMATION);
		createEReference(referenceLayoutInformationEClass, REFERENCE_LAYOUT_INFORMATION__OBJECT);

		attributeLayoutInformationEClass = createEClass(ATTRIBUTE_LAYOUT_INFORMATION);

		keywordLayoutInformationEClass = createEClass(KEYWORD_LAYOUT_INFORMATION);

		minimalLayoutInformationEClass = createEClass(MINIMAL_LAYOUT_INFORMATION);
		createEAttribute(minimalLayoutInformationEClass, MINIMAL_LAYOUT_INFORMATION__LENGTH);
		createEReference(minimalLayoutInformationEClass, MINIMAL_LAYOUT_INFORMATION__ROOT_LAYOUT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents()
	{
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		referenceLayoutInformationEClass.getESuperTypes().add(this.getLayoutInformation());
		attributeLayoutInformationEClass.getESuperTypes().add(this.getLayoutInformation());
		keywordLayoutInformationEClass.getESuperTypes().add(this.getLayoutInformation());
		minimalLayoutInformationEClass.getESuperTypes().add(this.getReferenceLayoutInformation());

		// Initialize classes and features; add operations and parameters
		initEClass(layoutInformationEClass, LayoutInformation.class, "LayoutInformation", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLayoutInformation_StartOffset(), ecorePackage.getEInt(), "startOffset", null, 1, 1, LayoutInformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLayoutInformation_HiddenTokenText(), ecorePackage.getEString(), "hiddenTokenText", null, 0, 1, LayoutInformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLayoutInformation_VisibleTokenText(), ecorePackage.getEString(), "visibleTokenText", null, 0, 1, LayoutInformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLayoutInformation_SyntaxElementID(), ecorePackage.getEString(), "syntaxElementID", null, 0, 1, LayoutInformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(referenceLayoutInformationEClass, ReferenceLayoutInformation.class, "ReferenceLayoutInformation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getReferenceLayoutInformation_Object(), ecorePackage.getEObject(), null, "object", null, 1, 1, ReferenceLayoutInformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(attributeLayoutInformationEClass, AttributeLayoutInformation.class, "AttributeLayoutInformation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(keywordLayoutInformationEClass, KeywordLayoutInformation.class, "KeywordLayoutInformation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(minimalLayoutInformationEClass, MinimalLayoutInformation.class, "MinimalLayoutInformation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMinimalLayoutInformation_Length(), ecorePackage.getEInt(), "length", null, 1, 1, MinimalLayoutInformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMinimalLayoutInformation_RootLayout(), this.getLayoutInformation(), null, "rootLayout", null, 1, 1, MinimalLayoutInformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(minimalLayoutInformationEClass, ecorePackage.getEString(), "getSourceString", 1, 1, IS_UNIQUE, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);
	}

} //LayoutPackageImpl
