/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.expressions.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import tools.mdsd.jamopp.model.java.expressions.util.ExpressionsAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ExpressionsItemProviderAdapterFactory extends ExpressionsAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExpressionsItemProviderAdapterFactory()
	{
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.ExpressionList} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionListItemProvider expressionListItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.ExpressionList}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpressionListAdapter()
	{
		if (expressionListItemProvider == null)
		{
			expressionListItemProvider = new ExpressionListItemProvider(this);
		}

		return expressionListItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.AssignmentExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssignmentExpressionItemProvider assignmentExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.AssignmentExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAssignmentExpressionAdapter()
	{
		if (assignmentExpressionItemProvider == null)
		{
			assignmentExpressionItemProvider = new AssignmentExpressionItemProvider(this);
		}

		return assignmentExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.ConditionalExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionalExpressionItemProvider conditionalExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.ConditionalExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConditionalExpressionAdapter()
	{
		if (conditionalExpressionItemProvider == null)
		{
			conditionalExpressionItemProvider = new ConditionalExpressionItemProvider(this);
		}

		return conditionalExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.ConditionalOrExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionalOrExpressionItemProvider conditionalOrExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.ConditionalOrExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConditionalOrExpressionAdapter()
	{
		if (conditionalOrExpressionItemProvider == null)
		{
			conditionalOrExpressionItemProvider = new ConditionalOrExpressionItemProvider(this);
		}

		return conditionalOrExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.ConditionalAndExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionalAndExpressionItemProvider conditionalAndExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.ConditionalAndExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConditionalAndExpressionAdapter()
	{
		if (conditionalAndExpressionItemProvider == null)
		{
			conditionalAndExpressionItemProvider = new ConditionalAndExpressionItemProvider(this);
		}

		return conditionalAndExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.InclusiveOrExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InclusiveOrExpressionItemProvider inclusiveOrExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.InclusiveOrExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInclusiveOrExpressionAdapter()
	{
		if (inclusiveOrExpressionItemProvider == null)
		{
			inclusiveOrExpressionItemProvider = new InclusiveOrExpressionItemProvider(this);
		}

		return inclusiveOrExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.ExclusiveOrExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExclusiveOrExpressionItemProvider exclusiveOrExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.ExclusiveOrExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExclusiveOrExpressionAdapter()
	{
		if (exclusiveOrExpressionItemProvider == null)
		{
			exclusiveOrExpressionItemProvider = new ExclusiveOrExpressionItemProvider(this);
		}

		return exclusiveOrExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.AndExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AndExpressionItemProvider andExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.AndExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAndExpressionAdapter()
	{
		if (andExpressionItemProvider == null)
		{
			andExpressionItemProvider = new AndExpressionItemProvider(this);
		}

		return andExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.EqualityExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EqualityExpressionItemProvider equalityExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.EqualityExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEqualityExpressionAdapter()
	{
		if (equalityExpressionItemProvider == null)
		{
			equalityExpressionItemProvider = new EqualityExpressionItemProvider(this);
		}

		return equalityExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.InstanceOfExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstanceOfExpressionItemProvider instanceOfExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.InstanceOfExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstanceOfExpressionAdapter()
	{
		if (instanceOfExpressionItemProvider == null)
		{
			instanceOfExpressionItemProvider = new InstanceOfExpressionItemProvider(this);
		}

		return instanceOfExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.RelationExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelationExpressionItemProvider relationExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.RelationExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRelationExpressionAdapter()
	{
		if (relationExpressionItemProvider == null)
		{
			relationExpressionItemProvider = new RelationExpressionItemProvider(this);
		}

		return relationExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.ShiftExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ShiftExpressionItemProvider shiftExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.ShiftExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createShiftExpressionAdapter()
	{
		if (shiftExpressionItemProvider == null)
		{
			shiftExpressionItemProvider = new ShiftExpressionItemProvider(this);
		}

		return shiftExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.AdditiveExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AdditiveExpressionItemProvider additiveExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.AdditiveExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAdditiveExpressionAdapter()
	{
		if (additiveExpressionItemProvider == null)
		{
			additiveExpressionItemProvider = new AdditiveExpressionItemProvider(this);
		}

		return additiveExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.MultiplicativeExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiplicativeExpressionItemProvider multiplicativeExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.MultiplicativeExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultiplicativeExpressionAdapter()
	{
		if (multiplicativeExpressionItemProvider == null)
		{
			multiplicativeExpressionItemProvider = new MultiplicativeExpressionItemProvider(this);
		}

		return multiplicativeExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.UnaryExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnaryExpressionItemProvider unaryExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.UnaryExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnaryExpressionAdapter()
	{
		if (unaryExpressionItemProvider == null)
		{
			unaryExpressionItemProvider = new UnaryExpressionItemProvider(this);
		}

		return unaryExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.PrefixUnaryModificationExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrefixUnaryModificationExpressionItemProvider prefixUnaryModificationExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.PrefixUnaryModificationExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrefixUnaryModificationExpressionAdapter()
	{
		if (prefixUnaryModificationExpressionItemProvider == null)
		{
			prefixUnaryModificationExpressionItemProvider = new PrefixUnaryModificationExpressionItemProvider(this);
		}

		return prefixUnaryModificationExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.SuffixUnaryModificationExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SuffixUnaryModificationExpressionItemProvider suffixUnaryModificationExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.SuffixUnaryModificationExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSuffixUnaryModificationExpressionAdapter()
	{
		if (suffixUnaryModificationExpressionItemProvider == null)
		{
			suffixUnaryModificationExpressionItemProvider = new SuffixUnaryModificationExpressionItemProvider(this);
		}

		return suffixUnaryModificationExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.CastExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CastExpressionItemProvider castExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.CastExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCastExpressionAdapter()
	{
		if (castExpressionItemProvider == null)
		{
			castExpressionItemProvider = new CastExpressionItemProvider(this);
		}

		return castExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.NestedExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NestedExpressionItemProvider nestedExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.NestedExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNestedExpressionAdapter()
	{
		if (nestedExpressionItemProvider == null)
		{
			nestedExpressionItemProvider = new NestedExpressionItemProvider(this);
		}

		return nestedExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.PrimaryExpressionReferenceExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimaryExpressionReferenceExpressionItemProvider primaryExpressionReferenceExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.PrimaryExpressionReferenceExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimaryExpressionReferenceExpressionAdapter()
	{
		if (primaryExpressionReferenceExpressionItemProvider == null)
		{
			primaryExpressionReferenceExpressionItemProvider = new PrimaryExpressionReferenceExpressionItemProvider(this);
		}

		return primaryExpressionReferenceExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.ClassTypeConstructorReferenceExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClassTypeConstructorReferenceExpressionItemProvider classTypeConstructorReferenceExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.ClassTypeConstructorReferenceExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClassTypeConstructorReferenceExpressionAdapter()
	{
		if (classTypeConstructorReferenceExpressionItemProvider == null)
		{
			classTypeConstructorReferenceExpressionItemProvider = new ClassTypeConstructorReferenceExpressionItemProvider(this);
		}

		return classTypeConstructorReferenceExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.ArrayConstructorReferenceExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayConstructorReferenceExpressionItemProvider arrayConstructorReferenceExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.ArrayConstructorReferenceExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayConstructorReferenceExpressionAdapter()
	{
		if (arrayConstructorReferenceExpressionItemProvider == null)
		{
			arrayConstructorReferenceExpressionItemProvider = new ArrayConstructorReferenceExpressionItemProvider(this);
		}

		return arrayConstructorReferenceExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.LambdaExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LambdaExpressionItemProvider lambdaExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.LambdaExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLambdaExpressionAdapter()
	{
		if (lambdaExpressionItemProvider == null)
		{
			lambdaExpressionItemProvider = new LambdaExpressionItemProvider(this);
		}

		return lambdaExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.ExplicitlyTypedLambdaParameters} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExplicitlyTypedLambdaParametersItemProvider explicitlyTypedLambdaParametersItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.ExplicitlyTypedLambdaParameters}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExplicitlyTypedLambdaParametersAdapter()
	{
		if (explicitlyTypedLambdaParametersItemProvider == null)
		{
			explicitlyTypedLambdaParametersItemProvider = new ExplicitlyTypedLambdaParametersItemProvider(this);
		}

		return explicitlyTypedLambdaParametersItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.ImplicitlyTypedLambdaParameters} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImplicitlyTypedLambdaParametersItemProvider implicitlyTypedLambdaParametersItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.ImplicitlyTypedLambdaParameters}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createImplicitlyTypedLambdaParametersAdapter()
	{
		if (implicitlyTypedLambdaParametersItemProvider == null)
		{
			implicitlyTypedLambdaParametersItemProvider = new ImplicitlyTypedLambdaParametersItemProvider(this);
		}

		return implicitlyTypedLambdaParametersItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.expressions.SingleImplicitLambdaParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleImplicitLambdaParameterItemProvider singleImplicitLambdaParameterItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.expressions.SingleImplicitLambdaParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleImplicitLambdaParameterAdapter()
	{
		if (singleImplicitLambdaParameterItemProvider == null)
		{
			singleImplicitLambdaParameterItemProvider = new SingleImplicitLambdaParameterItemProvider(this);
		}

		return singleImplicitLambdaParameterItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory()
	{
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory)
	{
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type)
	{
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type)
	{
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type)
	{
		if (isFactoryForType(type))
		{
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter)))
			{
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification)
	{
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null)
		{
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose()
	{
		if (expressionListItemProvider != null) expressionListItemProvider.dispose();
		if (assignmentExpressionItemProvider != null) assignmentExpressionItemProvider.dispose();
		if (conditionalExpressionItemProvider != null) conditionalExpressionItemProvider.dispose();
		if (conditionalOrExpressionItemProvider != null) conditionalOrExpressionItemProvider.dispose();
		if (conditionalAndExpressionItemProvider != null) conditionalAndExpressionItemProvider.dispose();
		if (inclusiveOrExpressionItemProvider != null) inclusiveOrExpressionItemProvider.dispose();
		if (exclusiveOrExpressionItemProvider != null) exclusiveOrExpressionItemProvider.dispose();
		if (andExpressionItemProvider != null) andExpressionItemProvider.dispose();
		if (equalityExpressionItemProvider != null) equalityExpressionItemProvider.dispose();
		if (instanceOfExpressionItemProvider != null) instanceOfExpressionItemProvider.dispose();
		if (relationExpressionItemProvider != null) relationExpressionItemProvider.dispose();
		if (shiftExpressionItemProvider != null) shiftExpressionItemProvider.dispose();
		if (additiveExpressionItemProvider != null) additiveExpressionItemProvider.dispose();
		if (multiplicativeExpressionItemProvider != null) multiplicativeExpressionItemProvider.dispose();
		if (unaryExpressionItemProvider != null) unaryExpressionItemProvider.dispose();
		if (prefixUnaryModificationExpressionItemProvider != null) prefixUnaryModificationExpressionItemProvider.dispose();
		if (suffixUnaryModificationExpressionItemProvider != null) suffixUnaryModificationExpressionItemProvider.dispose();
		if (castExpressionItemProvider != null) castExpressionItemProvider.dispose();
		if (nestedExpressionItemProvider != null) nestedExpressionItemProvider.dispose();
		if (primaryExpressionReferenceExpressionItemProvider != null) primaryExpressionReferenceExpressionItemProvider.dispose();
		if (classTypeConstructorReferenceExpressionItemProvider != null) classTypeConstructorReferenceExpressionItemProvider.dispose();
		if (arrayConstructorReferenceExpressionItemProvider != null) arrayConstructorReferenceExpressionItemProvider.dispose();
		if (lambdaExpressionItemProvider != null) lambdaExpressionItemProvider.dispose();
		if (explicitlyTypedLambdaParametersItemProvider != null) explicitlyTypedLambdaParametersItemProvider.dispose();
		if (implicitlyTypedLambdaParametersItemProvider != null) implicitlyTypedLambdaParametersItemProvider.dispose();
		if (singleImplicitLambdaParameterItemProvider != null) singleImplicitLambdaParameterItemProvider.dispose();
	}

}
