/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.literals.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import tools.mdsd.jamopp.model.java.literals.util.LiteralsAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class LiteralsItemProviderAdapterFactory extends LiteralsAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LiteralsItemProviderAdapterFactory()
	{
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.BooleanLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanLiteralItemProvider booleanLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.BooleanLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBooleanLiteralAdapter()
	{
		if (booleanLiteralItemProvider == null)
		{
			booleanLiteralItemProvider = new BooleanLiteralItemProvider(this);
		}

		return booleanLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.CharacterLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CharacterLiteralItemProvider characterLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.CharacterLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCharacterLiteralAdapter()
	{
		if (characterLiteralItemProvider == null)
		{
			characterLiteralItemProvider = new CharacterLiteralItemProvider(this);
		}

		return characterLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.DecimalFloatLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DecimalFloatLiteralItemProvider decimalFloatLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.DecimalFloatLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDecimalFloatLiteralAdapter()
	{
		if (decimalFloatLiteralItemProvider == null)
		{
			decimalFloatLiteralItemProvider = new DecimalFloatLiteralItemProvider(this);
		}

		return decimalFloatLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.HexFloatLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HexFloatLiteralItemProvider hexFloatLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.HexFloatLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHexFloatLiteralAdapter()
	{
		if (hexFloatLiteralItemProvider == null)
		{
			hexFloatLiteralItemProvider = new HexFloatLiteralItemProvider(this);
		}

		return hexFloatLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.DecimalDoubleLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DecimalDoubleLiteralItemProvider decimalDoubleLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.DecimalDoubleLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDecimalDoubleLiteralAdapter()
	{
		if (decimalDoubleLiteralItemProvider == null)
		{
			decimalDoubleLiteralItemProvider = new DecimalDoubleLiteralItemProvider(this);
		}

		return decimalDoubleLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.HexDoubleLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HexDoubleLiteralItemProvider hexDoubleLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.HexDoubleLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHexDoubleLiteralAdapter()
	{
		if (hexDoubleLiteralItemProvider == null)
		{
			hexDoubleLiteralItemProvider = new HexDoubleLiteralItemProvider(this);
		}

		return hexDoubleLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.DecimalIntegerLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DecimalIntegerLiteralItemProvider decimalIntegerLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.DecimalIntegerLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDecimalIntegerLiteralAdapter()
	{
		if (decimalIntegerLiteralItemProvider == null)
		{
			decimalIntegerLiteralItemProvider = new DecimalIntegerLiteralItemProvider(this);
		}

		return decimalIntegerLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.HexIntegerLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HexIntegerLiteralItemProvider hexIntegerLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.HexIntegerLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHexIntegerLiteralAdapter()
	{
		if (hexIntegerLiteralItemProvider == null)
		{
			hexIntegerLiteralItemProvider = new HexIntegerLiteralItemProvider(this);
		}

		return hexIntegerLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.OctalIntegerLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OctalIntegerLiteralItemProvider octalIntegerLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.OctalIntegerLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOctalIntegerLiteralAdapter()
	{
		if (octalIntegerLiteralItemProvider == null)
		{
			octalIntegerLiteralItemProvider = new OctalIntegerLiteralItemProvider(this);
		}

		return octalIntegerLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.BinaryIntegerLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BinaryIntegerLiteralItemProvider binaryIntegerLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.BinaryIntegerLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBinaryIntegerLiteralAdapter()
	{
		if (binaryIntegerLiteralItemProvider == null)
		{
			binaryIntegerLiteralItemProvider = new BinaryIntegerLiteralItemProvider(this);
		}

		return binaryIntegerLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.DecimalLongLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DecimalLongLiteralItemProvider decimalLongLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.DecimalLongLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDecimalLongLiteralAdapter()
	{
		if (decimalLongLiteralItemProvider == null)
		{
			decimalLongLiteralItemProvider = new DecimalLongLiteralItemProvider(this);
		}

		return decimalLongLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.HexLongLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HexLongLiteralItemProvider hexLongLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.HexLongLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHexLongLiteralAdapter()
	{
		if (hexLongLiteralItemProvider == null)
		{
			hexLongLiteralItemProvider = new HexLongLiteralItemProvider(this);
		}

		return hexLongLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.OctalLongLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OctalLongLiteralItemProvider octalLongLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.OctalLongLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOctalLongLiteralAdapter()
	{
		if (octalLongLiteralItemProvider == null)
		{
			octalLongLiteralItemProvider = new OctalLongLiteralItemProvider(this);
		}

		return octalLongLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.BinaryLongLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BinaryLongLiteralItemProvider binaryLongLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.BinaryLongLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBinaryLongLiteralAdapter()
	{
		if (binaryLongLiteralItemProvider == null)
		{
			binaryLongLiteralItemProvider = new BinaryLongLiteralItemProvider(this);
		}

		return binaryLongLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.NullLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NullLiteralItemProvider nullLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.NullLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNullLiteralAdapter()
	{
		if (nullLiteralItemProvider == null)
		{
			nullLiteralItemProvider = new NullLiteralItemProvider(this);
		}

		return nullLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.Super} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SuperItemProvider superItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.Super}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSuperAdapter()
	{
		if (superItemProvider == null)
		{
			superItemProvider = new SuperItemProvider(this);
		}

		return superItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.literals.This} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ThisItemProvider thisItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.literals.This}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createThisAdapter()
	{
		if (thisItemProvider == null)
		{
			thisItemProvider = new ThisItemProvider(this);
		}

		return thisItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory()
	{
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory)
	{
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type)
	{
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type)
	{
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type)
	{
		if (isFactoryForType(type))
		{
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter)))
			{
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification)
	{
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null)
		{
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose()
	{
		if (booleanLiteralItemProvider != null) booleanLiteralItemProvider.dispose();
		if (characterLiteralItemProvider != null) characterLiteralItemProvider.dispose();
		if (decimalFloatLiteralItemProvider != null) decimalFloatLiteralItemProvider.dispose();
		if (hexFloatLiteralItemProvider != null) hexFloatLiteralItemProvider.dispose();
		if (decimalDoubleLiteralItemProvider != null) decimalDoubleLiteralItemProvider.dispose();
		if (hexDoubleLiteralItemProvider != null) hexDoubleLiteralItemProvider.dispose();
		if (decimalIntegerLiteralItemProvider != null) decimalIntegerLiteralItemProvider.dispose();
		if (hexIntegerLiteralItemProvider != null) hexIntegerLiteralItemProvider.dispose();
		if (octalIntegerLiteralItemProvider != null) octalIntegerLiteralItemProvider.dispose();
		if (binaryIntegerLiteralItemProvider != null) binaryIntegerLiteralItemProvider.dispose();
		if (decimalLongLiteralItemProvider != null) decimalLongLiteralItemProvider.dispose();
		if (hexLongLiteralItemProvider != null) hexLongLiteralItemProvider.dispose();
		if (octalLongLiteralItemProvider != null) octalLongLiteralItemProvider.dispose();
		if (binaryLongLiteralItemProvider != null) binaryLongLiteralItemProvider.dispose();
		if (nullLiteralItemProvider != null) nullLiteralItemProvider.dispose();
		if (superItemProvider != null) superItemProvider.dispose();
		if (thisItemProvider != null) thisItemProvider.dispose();
	}

}
