/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.modifiers.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import tools.mdsd.jamopp.model.java.modifiers.util.ModifiersAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ModifiersItemProviderAdapterFactory extends ModifiersAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModifiersItemProviderAdapterFactory()
	{
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Abstract} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AbstractItemProvider abstractItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Abstract}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstractAdapter()
	{
		if (abstractItemProvider == null)
		{
			abstractItemProvider = new AbstractItemProvider(this);
		}

		return abstractItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Final} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FinalItemProvider finalItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Final}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFinalAdapter()
	{
		if (finalItemProvider == null)
		{
			finalItemProvider = new FinalItemProvider(this);
		}

		return finalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Native} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NativeItemProvider nativeItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Native}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNativeAdapter()
	{
		if (nativeItemProvider == null)
		{
			nativeItemProvider = new NativeItemProvider(this);
		}

		return nativeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Protected} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProtectedItemProvider protectedItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Protected}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProtectedAdapter()
	{
		if (protectedItemProvider == null)
		{
			protectedItemProvider = new ProtectedItemProvider(this);
		}

		return protectedItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Public} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PublicItemProvider publicItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Public}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPublicAdapter()
	{
		if (publicItemProvider == null)
		{
			publicItemProvider = new PublicItemProvider(this);
		}

		return publicItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Private} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrivateItemProvider privateItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Private}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrivateAdapter()
	{
		if (privateItemProvider == null)
		{
			privateItemProvider = new PrivateItemProvider(this);
		}

		return privateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Static} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StaticItemProvider staticItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Static}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStaticAdapter()
	{
		if (staticItemProvider == null)
		{
			staticItemProvider = new StaticItemProvider(this);
		}

		return staticItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Strictfp} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StrictfpItemProvider strictfpItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Strictfp}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStrictfpAdapter()
	{
		if (strictfpItemProvider == null)
		{
			strictfpItemProvider = new StrictfpItemProvider(this);
		}

		return strictfpItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Synchronized} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SynchronizedItemProvider synchronizedItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Synchronized}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSynchronizedAdapter()
	{
		if (synchronizedItemProvider == null)
		{
			synchronizedItemProvider = new SynchronizedItemProvider(this);
		}

		return synchronizedItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Transient} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TransientItemProvider transientItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Transient}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTransientAdapter()
	{
		if (transientItemProvider == null)
		{
			transientItemProvider = new TransientItemProvider(this);
		}

		return transientItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Volatile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VolatileItemProvider volatileItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Volatile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVolatileAdapter()
	{
		if (volatileItemProvider == null)
		{
			volatileItemProvider = new VolatileItemProvider(this);
		}

		return volatileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Default} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DefaultItemProvider defaultItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Default}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDefaultAdapter()
	{
		if (defaultItemProvider == null)
		{
			defaultItemProvider = new DefaultItemProvider(this);
		}

		return defaultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Transitive} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TransitiveItemProvider transitiveItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Transitive}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTransitiveAdapter()
	{
		if (transitiveItemProvider == null)
		{
			transitiveItemProvider = new TransitiveItemProvider(this);
		}

		return transitiveItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.modifiers.Open} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OpenItemProvider openItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.modifiers.Open}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOpenAdapter()
	{
		if (openItemProvider == null)
		{
			openItemProvider = new OpenItemProvider(this);
		}

		return openItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory()
	{
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory)
	{
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type)
	{
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type)
	{
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type)
	{
		if (isFactoryForType(type))
		{
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter)))
			{
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification)
	{
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null)
		{
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose()
	{
		if (abstractItemProvider != null) abstractItemProvider.dispose();
		if (finalItemProvider != null) finalItemProvider.dispose();
		if (nativeItemProvider != null) nativeItemProvider.dispose();
		if (protectedItemProvider != null) protectedItemProvider.dispose();
		if (publicItemProvider != null) publicItemProvider.dispose();
		if (privateItemProvider != null) privateItemProvider.dispose();
		if (staticItemProvider != null) staticItemProvider.dispose();
		if (strictfpItemProvider != null) strictfpItemProvider.dispose();
		if (synchronizedItemProvider != null) synchronizedItemProvider.dispose();
		if (transientItemProvider != null) transientItemProvider.dispose();
		if (volatileItemProvider != null) volatileItemProvider.dispose();
		if (defaultItemProvider != null) defaultItemProvider.dispose();
		if (transitiveItemProvider != null) transitiveItemProvider.dispose();
		if (openItemProvider != null) openItemProvider.dispose();
	}

}
