/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.statements.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import tools.mdsd.jamopp.model.java.statements.util.StatementsAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class StatementsItemProviderAdapterFactory extends StatementsAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StatementsItemProviderAdapterFactory()
	{
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.Assert} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssertItemProvider assertItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.Assert}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAssertAdapter()
	{
		if (assertItemProvider == null)
		{
			assertItemProvider = new AssertItemProvider(this);
		}

		return assertItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.Break} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BreakItemProvider breakItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.Break}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBreakAdapter()
	{
		if (breakItemProvider == null)
		{
			breakItemProvider = new BreakItemProvider(this);
		}

		return breakItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.Block} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BlockItemProvider blockItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.Block}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlockAdapter()
	{
		if (blockItemProvider == null)
		{
			blockItemProvider = new BlockItemProvider(this);
		}

		return blockItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.CatchBlock} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CatchBlockItemProvider catchBlockItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.CatchBlock}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCatchBlockAdapter()
	{
		if (catchBlockItemProvider == null)
		{
			catchBlockItemProvider = new CatchBlockItemProvider(this);
		}

		return catchBlockItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.Condition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionItemProvider conditionItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.Condition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConditionAdapter()
	{
		if (conditionItemProvider == null)
		{
			conditionItemProvider = new ConditionItemProvider(this);
		}

		return conditionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.Continue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ContinueItemProvider continueItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.Continue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createContinueAdapter()
	{
		if (continueItemProvider == null)
		{
			continueItemProvider = new ContinueItemProvider(this);
		}

		return continueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.DefaultSwitchCase} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DefaultSwitchCaseItemProvider defaultSwitchCaseItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.DefaultSwitchCase}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDefaultSwitchCaseAdapter()
	{
		if (defaultSwitchCaseItemProvider == null)
		{
			defaultSwitchCaseItemProvider = new DefaultSwitchCaseItemProvider(this);
		}

		return defaultSwitchCaseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.DoWhileLoop} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DoWhileLoopItemProvider doWhileLoopItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.DoWhileLoop}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDoWhileLoopAdapter()
	{
		if (doWhileLoopItemProvider == null)
		{
			doWhileLoopItemProvider = new DoWhileLoopItemProvider(this);
		}

		return doWhileLoopItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.EmptyStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EmptyStatementItemProvider emptyStatementItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.EmptyStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEmptyStatementAdapter()
	{
		if (emptyStatementItemProvider == null)
		{
			emptyStatementItemProvider = new EmptyStatementItemProvider(this);
		}

		return emptyStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.ExpressionStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionStatementItemProvider expressionStatementItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.ExpressionStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpressionStatementAdapter()
	{
		if (expressionStatementItemProvider == null)
		{
			expressionStatementItemProvider = new ExpressionStatementItemProvider(this);
		}

		return expressionStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.ForLoop} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ForLoopItemProvider forLoopItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.ForLoop}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createForLoopAdapter()
	{
		if (forLoopItemProvider == null)
		{
			forLoopItemProvider = new ForLoopItemProvider(this);
		}

		return forLoopItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.ForEachLoop} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ForEachLoopItemProvider forEachLoopItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.ForEachLoop}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createForEachLoopAdapter()
	{
		if (forEachLoopItemProvider == null)
		{
			forEachLoopItemProvider = new ForEachLoopItemProvider(this);
		}

		return forEachLoopItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.JumpLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JumpLabelItemProvider jumpLabelItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.JumpLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJumpLabelAdapter()
	{
		if (jumpLabelItemProvider == null)
		{
			jumpLabelItemProvider = new JumpLabelItemProvider(this);
		}

		return jumpLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.LocalVariableStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LocalVariableStatementItemProvider localVariableStatementItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.LocalVariableStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLocalVariableStatementAdapter()
	{
		if (localVariableStatementItemProvider == null)
		{
			localVariableStatementItemProvider = new LocalVariableStatementItemProvider(this);
		}

		return localVariableStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.NormalSwitchCase} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NormalSwitchCaseItemProvider normalSwitchCaseItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.NormalSwitchCase}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNormalSwitchCaseAdapter()
	{
		if (normalSwitchCaseItemProvider == null)
		{
			normalSwitchCaseItemProvider = new NormalSwitchCaseItemProvider(this);
		}

		return normalSwitchCaseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.Return} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReturnItemProvider returnItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.Return}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReturnAdapter()
	{
		if (returnItemProvider == null)
		{
			returnItemProvider = new ReturnItemProvider(this);
		}

		return returnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.Switch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SwitchItemProvider switchItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.Switch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSwitchAdapter()
	{
		if (switchItemProvider == null)
		{
			switchItemProvider = new SwitchItemProvider(this);
		}

		return switchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.SynchronizedBlock} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SynchronizedBlockItemProvider synchronizedBlockItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.SynchronizedBlock}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSynchronizedBlockAdapter()
	{
		if (synchronizedBlockItemProvider == null)
		{
			synchronizedBlockItemProvider = new SynchronizedBlockItemProvider(this);
		}

		return synchronizedBlockItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.Throw} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ThrowItemProvider throwItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.Throw}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createThrowAdapter()
	{
		if (throwItemProvider == null)
		{
			throwItemProvider = new ThrowItemProvider(this);
		}

		return throwItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.TryBlock} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TryBlockItemProvider tryBlockItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.TryBlock}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTryBlockAdapter()
	{
		if (tryBlockItemProvider == null)
		{
			tryBlockItemProvider = new TryBlockItemProvider(this);
		}

		return tryBlockItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.WhileLoop} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WhileLoopItemProvider whileLoopItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.WhileLoop}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWhileLoopAdapter()
	{
		if (whileLoopItemProvider == null)
		{
			whileLoopItemProvider = new WhileLoopItemProvider(this);
		}

		return whileLoopItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.YieldStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected YieldStatementItemProvider yieldStatementItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.YieldStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createYieldStatementAdapter()
	{
		if (yieldStatementItemProvider == null)
		{
			yieldStatementItemProvider = new YieldStatementItemProvider(this);
		}

		return yieldStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.DefaultSwitchRule} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DefaultSwitchRuleItemProvider defaultSwitchRuleItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.DefaultSwitchRule}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDefaultSwitchRuleAdapter()
	{
		if (defaultSwitchRuleItemProvider == null)
		{
			defaultSwitchRuleItemProvider = new DefaultSwitchRuleItemProvider(this);
		}

		return defaultSwitchRuleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link tools.mdsd.jamopp.model.java.statements.NormalSwitchRule} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NormalSwitchRuleItemProvider normalSwitchRuleItemProvider;

	/**
	 * This creates an adapter for a {@link tools.mdsd.jamopp.model.java.statements.NormalSwitchRule}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNormalSwitchRuleAdapter()
	{
		if (normalSwitchRuleItemProvider == null)
		{
			normalSwitchRuleItemProvider = new NormalSwitchRuleItemProvider(this);
		}

		return normalSwitchRuleItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory()
	{
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory)
	{
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type)
	{
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type)
	{
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type)
	{
		if (isFactoryForType(type))
		{
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter)))
			{
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification)
	{
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null)
		{
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose()
	{
		if (assertItemProvider != null) assertItemProvider.dispose();
		if (breakItemProvider != null) breakItemProvider.dispose();
		if (blockItemProvider != null) blockItemProvider.dispose();
		if (catchBlockItemProvider != null) catchBlockItemProvider.dispose();
		if (conditionItemProvider != null) conditionItemProvider.dispose();
		if (continueItemProvider != null) continueItemProvider.dispose();
		if (defaultSwitchCaseItemProvider != null) defaultSwitchCaseItemProvider.dispose();
		if (doWhileLoopItemProvider != null) doWhileLoopItemProvider.dispose();
		if (emptyStatementItemProvider != null) emptyStatementItemProvider.dispose();
		if (expressionStatementItemProvider != null) expressionStatementItemProvider.dispose();
		if (forLoopItemProvider != null) forLoopItemProvider.dispose();
		if (forEachLoopItemProvider != null) forEachLoopItemProvider.dispose();
		if (jumpLabelItemProvider != null) jumpLabelItemProvider.dispose();
		if (localVariableStatementItemProvider != null) localVariableStatementItemProvider.dispose();
		if (normalSwitchCaseItemProvider != null) normalSwitchCaseItemProvider.dispose();
		if (returnItemProvider != null) returnItemProvider.dispose();
		if (switchItemProvider != null) switchItemProvider.dispose();
		if (synchronizedBlockItemProvider != null) synchronizedBlockItemProvider.dispose();
		if (throwItemProvider != null) throwItemProvider.dispose();
		if (tryBlockItemProvider != null) tryBlockItemProvider.dispose();
		if (whileLoopItemProvider != null) whileLoopItemProvider.dispose();
		if (yieldStatementItemProvider != null) yieldStatementItemProvider.dispose();
		if (defaultSwitchRuleItemProvider != null) defaultSwitchRuleItemProvider.dispose();
		if (normalSwitchRuleItemProvider != null) normalSwitchRuleItemProvider.dispose();
	}

}
