/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.commons.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import tools.mdsd.jamopp.commons.layout.LayoutInformation;

import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;

import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;

import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.CommonsPackage;

import tools.mdsd.jamopp.model.java.containers.CompilationUnit;

import tools.mdsd.jamopp.model.java.statements.Statement;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Commentable</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link tools.mdsd.jamopp.model.java.commons.impl.CommentableImpl#getLayoutInformations <em>Layout Informations</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class CommentableImpl extends MinimalEObjectImpl implements Commentable
{
	/**
	 * The cached value of the '{@link #getLayoutInformations() <em>Layout Informations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLayoutInformations()
	 * @generated
	 * @ordered
	 */
	protected EList<LayoutInformation> layoutInformations;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommentableImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return CommonsPackage.Literals.COMMENTABLE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<LayoutInformation> getLayoutInformations()
	{
		if (layoutInformations == null)
		{
			layoutInformations = new EObjectContainmentEList.Resolving<LayoutInformation>(LayoutInformation.class, this, CommonsPackage.COMMENTABLE__LAYOUT_INFORMATIONS);
		}
		return layoutInformations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ConcreteClassifier getConcreteClassifier(final String name)
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getConcreteClassifier((tools.mdsd.jamopp.model.java.commons.Commentable) this, name);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ConcreteClassifier> getConcreteClassifiers(final String packageName, final String classifierQuery)
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getConcreteClassifiers((tools.mdsd.jamopp.model.java.commons.Commentable) this, packageName, classifierQuery);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public tools.mdsd.jamopp.model.java.classifiers.Class getLibClass(final String name)
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getLibClass((tools.mdsd.jamopp.model.java.commons.Commentable) this, name);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Interface getLibInterface(final String name)
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getLibInterface((tools.mdsd.jamopp.model.java.commons.Commentable) this, name);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public tools.mdsd.jamopp.model.java.classifiers.Class getClassClass()
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getClassClass((tools.mdsd.jamopp.model.java.commons.Commentable) this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public tools.mdsd.jamopp.model.java.classifiers.Class getObjectClass()
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getObjectClass((tools.mdsd.jamopp.model.java.commons.Commentable) this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public tools.mdsd.jamopp.model.java.classifiers.Class getStringClass()
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getStringClass((tools.mdsd.jamopp.model.java.commons.Commentable) this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Interface getAnnotationInterface()
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getAnnotationInterface((tools.mdsd.jamopp.model.java.commons.Commentable) this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AnnotationInstance getContainingAnnotationInstance()
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getContainingAnnotationInstance((tools.mdsd.jamopp.model.java.commons.Commentable) this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AnonymousClass getContainingAnonymousClass()
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getContainingAnonymousClass((tools.mdsd.jamopp.model.java.commons.Commentable) this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ConcreteClassifier getContainingConcreteClassifier()
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getContainingConcreteClassifier((tools.mdsd.jamopp.model.java.commons.Commentable) this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CompilationUnit getContainingCompilationUnit()
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getContainingCompilationUnit((tools.mdsd.jamopp.model.java.commons.Commentable) this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getContainingPackageName()
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getContainingPackageName((tools.mdsd.jamopp.model.java.commons.Commentable) this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getContainingContainerName()
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getContainingContainerName((tools.mdsd.jamopp.model.java.commons.Commentable) this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ConcreteClassifier getParentConcreteClassifier()
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getParentConcreteClassifier((tools.mdsd.jamopp.model.java.commons.Commentable) this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject getParentByEType(final EClass type)
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getParentByEType((tools.mdsd.jamopp.model.java.commons.Commentable) this, (org.eclipse.emf.ecore.EClass) type);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject getFirstChildByEType(final EClass type)
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getFirstChildByEType((tools.mdsd.jamopp.model.java.commons.Commentable) this, (org.eclipse.emf.ecore.EClass) type);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public <T> T getParentByType(final Class<T> type)
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getParentByType((tools.mdsd.jamopp.model.java.commons.Commentable) this, type);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public <T> T getFirstChildByType(final Class<T> type)
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getFirstChildByType((tools.mdsd.jamopp.model.java.commons.Commentable) this, ( java.lang.Class<T>) type);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<EObject> getChildrenByEType(final EClass type)
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getChildrenByEType((tools.mdsd.jamopp.model.java.commons.Commentable) this, (org.eclipse.emf.ecore.EClass) type);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public <T> EList<T> getChildrenByType(final Class<T> type)
	{
		return tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.getChildrenByType((tools.mdsd.jamopp.model.java.commons.Commentable) this, ( java.lang.Class<T>) type);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addBeforeContainingStatement(final Statement statementToAdd)
	{
		tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.addBeforeContainingStatement((tools.mdsd.jamopp.model.java.commons.Commentable) this, (tools.mdsd.jamopp.model.java.statements.Statement) statementToAdd);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addAfterContainingStatement(final Statement statementToAdd)
	{
		tools.mdsd.jamopp.model.java.extensions.commons.CommentableExtension.addAfterContainingStatement((tools.mdsd.jamopp.model.java.commons.Commentable) this, (tools.mdsd.jamopp.model.java.statements.Statement) statementToAdd);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
	{
		switch (featureID)
		{
			case CommonsPackage.COMMENTABLE__LAYOUT_INFORMATIONS:
				return ((InternalEList<?>)getLayoutInformations()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType)
	{
		switch (featureID)
		{
			case CommonsPackage.COMMENTABLE__LAYOUT_INFORMATIONS:
				return getLayoutInformations();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue)
	{
		switch (featureID)
		{
			case CommonsPackage.COMMENTABLE__LAYOUT_INFORMATIONS:
				getLayoutInformations().clear();
				getLayoutInformations().addAll((Collection<? extends LayoutInformation>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID)
	{
		switch (featureID)
		{
			case CommonsPackage.COMMENTABLE__LAYOUT_INFORMATIONS:
				getLayoutInformations().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID)
	{
		switch (featureID)
		{
			case CommonsPackage.COMMENTABLE__LAYOUT_INFORMATIONS:
				return layoutInformations != null && !layoutInformations.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //CommentableImpl
