/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.expressions;

import org.eclipse.emf.common.util.EList;

import tools.mdsd.jamopp.model.java.operators.RelationOperator;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Relation Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link tools.mdsd.jamopp.model.java.expressions.RelationExpression#getChildren <em>Children</em>}</li>
 *   <li>{@link tools.mdsd.jamopp.model.java.expressions.RelationExpression#getRelationOperators <em>Relation Operators</em>}</li>
 * </ul>
 *
 * @see tools.mdsd.jamopp.model.java.expressions.ExpressionsPackage#getRelationExpression()
 * @model
 * @generated
 */
public interface RelationExpression extends InstanceOfExpressionChild
{
	/**
	 * Returns the value of the '<em><b>Children</b></em>' containment reference list.
	 * The list contents are of type {@link tools.mdsd.jamopp.model.java.expressions.RelationExpressionChild}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Children</em>' containment reference list.
	 * @see tools.mdsd.jamopp.model.java.expressions.ExpressionsPackage#getRelationExpression_Children()
	 * @model containment="true" resolveProxies="true" required="true"
	 * @generated
	 */
	EList<RelationExpressionChild> getChildren();

	/**
	 * Returns the value of the '<em><b>Relation Operators</b></em>' containment reference list.
	 * The list contents are of type {@link tools.mdsd.jamopp.model.java.operators.RelationOperator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Relation Operators</em>' containment reference list.
	 * @see tools.mdsd.jamopp.model.java.expressions.ExpressionsPackage#getRelationExpression_RelationOperators()
	 * @model containment="true" resolveProxies="true"
	 * @generated
	 */
	EList<RelationOperator> getRelationOperators();

} // RelationExpression
