/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.generics;

import tools.mdsd.jamopp.model.java.annotations.Annotable;

import tools.mdsd.jamopp.model.java.types.TypeReference;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Super Type Argument</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link tools.mdsd.jamopp.model.java.generics.SuperTypeArgument#getSuperType <em>Super Type</em>}</li>
 * </ul>
 *
 * @see tools.mdsd.jamopp.model.java.generics.GenericsPackage#getSuperTypeArgument()
 * @model
 * @generated
 */
public interface SuperTypeArgument extends Annotable, TypeArgument
{
	/**
	 * Returns the value of the '<em><b>Super Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Super Type</em>' containment reference.
	 * @see #setSuperType(TypeReference)
	 * @see tools.mdsd.jamopp.model.java.generics.GenericsPackage#getSuperTypeArgument_SuperType()
	 * @model containment="true" resolveProxies="true" required="true"
	 * @generated
	 */
	TypeReference getSuperType();

	/**
	 * Sets the value of the '{@link tools.mdsd.jamopp.model.java.generics.SuperTypeArgument#getSuperType <em>Super Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Super Type</em>' containment reference.
	 * @see #getSuperType()
	 * @generated
	 */
	void setSuperType(TypeReference value);

} // SuperTypeArgument
