/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.generics;

import org.eclipse.emf.common.util.EList;

import tools.mdsd.jamopp.model.java.annotations.Annotable;

import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;

import tools.mdsd.jamopp.model.java.commons.Commentable;

import tools.mdsd.jamopp.model.java.members.Member;

import tools.mdsd.jamopp.model.java.references.Reference;

import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Type Parameter</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link tools.mdsd.jamopp.model.java.generics.TypeParameter#getExtendTypes <em>Extend Types</em>}</li>
 * </ul>
 *
 * @see tools.mdsd.jamopp.model.java.generics.GenericsPackage#getTypeParameter()
 * @model
 * @generated
 */
public interface TypeParameter extends Classifier, Annotable
{
	/**
	 * Returns the value of the '<em><b>Extend Types</b></em>' containment reference list.
	 * The list contents are of type {@link tools.mdsd.jamopp.model.java.types.TypeReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Extend Types</em>' containment reference list.
	 * @see tools.mdsd.jamopp.model.java.generics.GenericsPackage#getTypeParameter_ExtendTypes()
	 * @model containment="true" resolveProxies="true"
	 * @generated
	 */
	EList<TypeReference> getExtendTypes();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * <!-- end-model-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	EList<ConcreteClassifier> getAllSuperClassifiers();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * <!-- end-model-doc -->
	 * @model
	 * @generated
	 */
	EList<Member> getAllMembers(Commentable context);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * <!-- end-model-doc -->
	 * @model
	 * @generated
	 */
	Type getBoundType(TypeReference typeReference, Reference reference);

} // TypeParameter
