/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.imports.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;

import tools.mdsd.jamopp.model.java.imports.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see tools.mdsd.jamopp.model.java.imports.ImportsPackage
 * @generated
 */
public class ImportsAdapterFactory extends AdapterFactoryImpl
{
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static ImportsPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ImportsAdapterFactory()
	{
		if (modelPackage == null)
		{
			modelPackage = ImportsPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object)
	{
		if (object == modelPackage)
		{
			return true;
		}
		if (object instanceof EObject)
		{
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImportsSwitch<Adapter> modelSwitch =
		new ImportsSwitch<Adapter>()
		{
			@Override
			public Adapter caseImport(Import object)
			{
				return createImportAdapter();
			}
			@Override
			public Adapter caseImportingElement(ImportingElement object)
			{
				return createImportingElementAdapter();
			}
			@Override
			public Adapter caseStaticImport(StaticImport object)
			{
				return createStaticImportAdapter();
			}
			@Override
			public Adapter caseClassifierImport(ClassifierImport object)
			{
				return createClassifierImportAdapter();
			}
			@Override
			public Adapter casePackageImport(PackageImport object)
			{
				return createPackageImportAdapter();
			}
			@Override
			public Adapter caseStaticClassifierImport(StaticClassifierImport object)
			{
				return createStaticClassifierImportAdapter();
			}
			@Override
			public Adapter caseStaticMemberImport(StaticMemberImport object)
			{
				return createStaticMemberImportAdapter();
			}
			@Override
			public Adapter caseCommentable(Commentable object)
			{
				return createCommentableAdapter();
			}
			@Override
			public Adapter caseNamespaceAwareElement(NamespaceAwareElement object)
			{
				return createNamespaceAwareElementAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object)
			{
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target)
	{
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link tools.mdsd.jamopp.model.java.imports.Import <em>Import</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see tools.mdsd.jamopp.model.java.imports.Import
	 * @generated
	 */
	public Adapter createImportAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link tools.mdsd.jamopp.model.java.imports.ImportingElement <em>Importing Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see tools.mdsd.jamopp.model.java.imports.ImportingElement
	 * @generated
	 */
	public Adapter createImportingElementAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link tools.mdsd.jamopp.model.java.imports.StaticImport <em>Static Import</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see tools.mdsd.jamopp.model.java.imports.StaticImport
	 * @generated
	 */
	public Adapter createStaticImportAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link tools.mdsd.jamopp.model.java.imports.ClassifierImport <em>Classifier Import</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see tools.mdsd.jamopp.model.java.imports.ClassifierImport
	 * @generated
	 */
	public Adapter createClassifierImportAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link tools.mdsd.jamopp.model.java.imports.PackageImport <em>Package Import</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see tools.mdsd.jamopp.model.java.imports.PackageImport
	 * @generated
	 */
	public Adapter createPackageImportAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link tools.mdsd.jamopp.model.java.imports.StaticClassifierImport <em>Static Classifier Import</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see tools.mdsd.jamopp.model.java.imports.StaticClassifierImport
	 * @generated
	 */
	public Adapter createStaticClassifierImportAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link tools.mdsd.jamopp.model.java.imports.StaticMemberImport <em>Static Member Import</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see tools.mdsd.jamopp.model.java.imports.StaticMemberImport
	 * @generated
	 */
	public Adapter createStaticMemberImportAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link tools.mdsd.jamopp.model.java.commons.Commentable <em>Commentable</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see tools.mdsd.jamopp.model.java.commons.Commentable
	 * @generated
	 */
	public Adapter createCommentableAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement <em>Namespace Aware Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement
	 * @generated
	 */
	public Adapter createNamespaceAwareElementAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter()
	{
		return null;
	}

} //ImportsAdapterFactory
