/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.instantiations;

import tools.mdsd.jamopp.model.java.literals.Self;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Explicit Constructor Call</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link tools.mdsd.jamopp.model.java.instantiations.ExplicitConstructorCall#getCallTarget <em>Call Target</em>}</li>
 * </ul>
 *
 * @see tools.mdsd.jamopp.model.java.instantiations.InstantiationsPackage#getExplicitConstructorCall()
 * @model
 * @generated
 */
public interface ExplicitConstructorCall extends Instantiation
{
	/**
	 * Returns the value of the '<em><b>Call Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Call Target</em>' containment reference.
	 * @see #setCallTarget(Self)
	 * @see tools.mdsd.jamopp.model.java.instantiations.InstantiationsPackage#getExplicitConstructorCall_CallTarget()
	 * @model containment="true" resolveProxies="true" required="true"
	 * @generated
	 */
	Self getCallTarget();

	/**
	 * Sets the value of the '{@link tools.mdsd.jamopp.model.java.instantiations.ExplicitConstructorCall#getCallTarget <em>Call Target</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Call Target</em>' containment reference.
	 * @see #getCallTarget()
	 * @generated
	 */
	void setCallTarget(Self value);

} // ExplicitConstructorCall
