/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.instantiations;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see tools.mdsd.jamopp.model.java.instantiations.InstantiationsPackage
 * @generated
 */
public interface InstantiationsFactory extends EFactory
{
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	InstantiationsFactory eINSTANCE = tools.mdsd.jamopp.model.java.instantiations.impl.InstantiationsFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>New Constructor Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>New Constructor Call</em>'.
	 * @generated
	 */
	NewConstructorCall createNewConstructorCall();

	/**
	 * Returns a new object of class '<em>New Constructor Call With Inferred Type Arguments</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>New Constructor Call With Inferred Type Arguments</em>'.
	 * @generated
	 */
	NewConstructorCallWithInferredTypeArguments createNewConstructorCallWithInferredTypeArguments();

	/**
	 * Returns a new object of class '<em>Explicit Constructor Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Explicit Constructor Call</em>'.
	 * @generated
	 */
	ExplicitConstructorCall createExplicitConstructorCall();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	InstantiationsPackage getInstantiationsPackage();

} //InstantiationsFactory
