/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.literals;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

import tools.mdsd.jamopp.model.java.commons.CommonsPackage;

import tools.mdsd.jamopp.model.java.expressions.ExpressionsPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see tools.mdsd.jamopp.model.java.literals.LiteralsFactory
 * @model kind="package"
 * @generated
 */
public interface LiteralsPackage extends EPackage
{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "literals";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.emftext.org/java/literals";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "literals";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	LiteralsPackage eINSTANCE = tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl.init();

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.LiteralImpl <em>Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getLiteral()
	 * @generated
	 */
	int LITERAL = 0;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL__LAYOUT_INFORMATIONS = ExpressionsPackage.PRIMARY_EXPRESSION__LAYOUT_INFORMATIONS;

	/**
	 * The number of structural features of the '<em>Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_FEATURE_COUNT = ExpressionsPackage.PRIMARY_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.SelfImpl <em>Self</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.SelfImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getSelf()
	 * @generated
	 */
	int SELF = 1;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF__LAYOUT_INFORMATIONS = CommonsPackage.COMMENTABLE__LAYOUT_INFORMATIONS;

	/**
	 * The number of structural features of the '<em>Self</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_FEATURE_COUNT = CommonsPackage.COMMENTABLE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.BooleanLiteralImpl <em>Boolean Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.BooleanLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getBooleanLiteral()
	 * @generated
	 */
	int BOOLEAN_LITERAL = 2;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_LITERAL__LAYOUT_INFORMATIONS = LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_LITERAL__VALUE = LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Boolean Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_LITERAL_FEATURE_COUNT = LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.CharacterLiteralImpl <em>Character Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.CharacterLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getCharacterLiteral()
	 * @generated
	 */
	int CHARACTER_LITERAL = 3;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHARACTER_LITERAL__LAYOUT_INFORMATIONS = LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHARACTER_LITERAL__VALUE = LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Character Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHARACTER_LITERAL_FEATURE_COUNT = LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.FloatLiteralImpl <em>Float Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.FloatLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getFloatLiteral()
	 * @generated
	 */
	int FLOAT_LITERAL = 4;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLOAT_LITERAL__LAYOUT_INFORMATIONS = LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The number of structural features of the '<em>Float Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLOAT_LITERAL_FEATURE_COUNT = LITERAL_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.DecimalFloatLiteralImpl <em>Decimal Float Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.DecimalFloatLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getDecimalFloatLiteral()
	 * @generated
	 */
	int DECIMAL_FLOAT_LITERAL = 5;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECIMAL_FLOAT_LITERAL__LAYOUT_INFORMATIONS = FLOAT_LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Decimal Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECIMAL_FLOAT_LITERAL__DECIMAL_VALUE = FLOAT_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Decimal Float Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECIMAL_FLOAT_LITERAL_FEATURE_COUNT = FLOAT_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.HexFloatLiteralImpl <em>Hex Float Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.HexFloatLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getHexFloatLiteral()
	 * @generated
	 */
	int HEX_FLOAT_LITERAL = 6;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEX_FLOAT_LITERAL__LAYOUT_INFORMATIONS = FLOAT_LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Hex Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEX_FLOAT_LITERAL__HEX_VALUE = FLOAT_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Hex Float Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEX_FLOAT_LITERAL_FEATURE_COUNT = FLOAT_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.DoubleLiteralImpl <em>Double Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.DoubleLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getDoubleLiteral()
	 * @generated
	 */
	int DOUBLE_LITERAL = 7;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_LITERAL__LAYOUT_INFORMATIONS = LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The number of structural features of the '<em>Double Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOUBLE_LITERAL_FEATURE_COUNT = LITERAL_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.DecimalDoubleLiteralImpl <em>Decimal Double Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.DecimalDoubleLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getDecimalDoubleLiteral()
	 * @generated
	 */
	int DECIMAL_DOUBLE_LITERAL = 8;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECIMAL_DOUBLE_LITERAL__LAYOUT_INFORMATIONS = DOUBLE_LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Decimal Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECIMAL_DOUBLE_LITERAL__DECIMAL_VALUE = DOUBLE_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Decimal Double Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECIMAL_DOUBLE_LITERAL_FEATURE_COUNT = DOUBLE_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.HexDoubleLiteralImpl <em>Hex Double Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.HexDoubleLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getHexDoubleLiteral()
	 * @generated
	 */
	int HEX_DOUBLE_LITERAL = 9;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEX_DOUBLE_LITERAL__LAYOUT_INFORMATIONS = DOUBLE_LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Hex Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEX_DOUBLE_LITERAL__HEX_VALUE = DOUBLE_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Hex Double Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEX_DOUBLE_LITERAL_FEATURE_COUNT = DOUBLE_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.IntegerLiteralImpl <em>Integer Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.IntegerLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getIntegerLiteral()
	 * @generated
	 */
	int INTEGER_LITERAL = 10;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_LITERAL__LAYOUT_INFORMATIONS = LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The number of structural features of the '<em>Integer Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_LITERAL_FEATURE_COUNT = LITERAL_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.DecimalIntegerLiteralImpl <em>Decimal Integer Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.DecimalIntegerLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getDecimalIntegerLiteral()
	 * @generated
	 */
	int DECIMAL_INTEGER_LITERAL = 11;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECIMAL_INTEGER_LITERAL__LAYOUT_INFORMATIONS = INTEGER_LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Decimal Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECIMAL_INTEGER_LITERAL__DECIMAL_VALUE = INTEGER_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Decimal Integer Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECIMAL_INTEGER_LITERAL_FEATURE_COUNT = INTEGER_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.HexIntegerLiteralImpl <em>Hex Integer Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.HexIntegerLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getHexIntegerLiteral()
	 * @generated
	 */
	int HEX_INTEGER_LITERAL = 12;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEX_INTEGER_LITERAL__LAYOUT_INFORMATIONS = INTEGER_LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Hex Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEX_INTEGER_LITERAL__HEX_VALUE = INTEGER_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Hex Integer Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEX_INTEGER_LITERAL_FEATURE_COUNT = INTEGER_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.OctalIntegerLiteralImpl <em>Octal Integer Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.OctalIntegerLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getOctalIntegerLiteral()
	 * @generated
	 */
	int OCTAL_INTEGER_LITERAL = 13;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OCTAL_INTEGER_LITERAL__LAYOUT_INFORMATIONS = INTEGER_LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Octal Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OCTAL_INTEGER_LITERAL__OCTAL_VALUE = INTEGER_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Octal Integer Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OCTAL_INTEGER_LITERAL_FEATURE_COUNT = INTEGER_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.BinaryIntegerLiteralImpl <em>Binary Integer Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.BinaryIntegerLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getBinaryIntegerLiteral()
	 * @generated
	 */
	int BINARY_INTEGER_LITERAL = 14;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_INTEGER_LITERAL__LAYOUT_INFORMATIONS = INTEGER_LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Binary Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_INTEGER_LITERAL__BINARY_VALUE = INTEGER_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Binary Integer Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_INTEGER_LITERAL_FEATURE_COUNT = INTEGER_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.LongLiteralImpl <em>Long Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LongLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getLongLiteral()
	 * @generated
	 */
	int LONG_LITERAL = 15;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LONG_LITERAL__LAYOUT_INFORMATIONS = LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The number of structural features of the '<em>Long Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LONG_LITERAL_FEATURE_COUNT = LITERAL_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.DecimalLongLiteralImpl <em>Decimal Long Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.DecimalLongLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getDecimalLongLiteral()
	 * @generated
	 */
	int DECIMAL_LONG_LITERAL = 16;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECIMAL_LONG_LITERAL__LAYOUT_INFORMATIONS = LONG_LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Decimal Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECIMAL_LONG_LITERAL__DECIMAL_VALUE = LONG_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Decimal Long Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DECIMAL_LONG_LITERAL_FEATURE_COUNT = LONG_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.HexLongLiteralImpl <em>Hex Long Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.HexLongLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getHexLongLiteral()
	 * @generated
	 */
	int HEX_LONG_LITERAL = 17;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEX_LONG_LITERAL__LAYOUT_INFORMATIONS = LONG_LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Hex Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEX_LONG_LITERAL__HEX_VALUE = LONG_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Hex Long Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HEX_LONG_LITERAL_FEATURE_COUNT = LONG_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.OctalLongLiteralImpl <em>Octal Long Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.OctalLongLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getOctalLongLiteral()
	 * @generated
	 */
	int OCTAL_LONG_LITERAL = 18;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OCTAL_LONG_LITERAL__LAYOUT_INFORMATIONS = LONG_LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Octal Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OCTAL_LONG_LITERAL__OCTAL_VALUE = LONG_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Octal Long Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OCTAL_LONG_LITERAL_FEATURE_COUNT = LONG_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.BinaryLongLiteralImpl <em>Binary Long Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.BinaryLongLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getBinaryLongLiteral()
	 * @generated
	 */
	int BINARY_LONG_LITERAL = 19;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_LONG_LITERAL__LAYOUT_INFORMATIONS = LONG_LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The feature id for the '<em><b>Binary Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_LONG_LITERAL__BINARY_VALUE = LONG_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Binary Long Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BINARY_LONG_LITERAL_FEATURE_COUNT = LONG_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.NullLiteralImpl <em>Null Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.NullLiteralImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getNullLiteral()
	 * @generated
	 */
	int NULL_LITERAL = 20;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_LITERAL__LAYOUT_INFORMATIONS = LITERAL__LAYOUT_INFORMATIONS;

	/**
	 * The number of structural features of the '<em>Null Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_LITERAL_FEATURE_COUNT = LITERAL_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.SuperImpl <em>Super</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.SuperImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getSuper()
	 * @generated
	 */
	int SUPER = 21;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUPER__LAYOUT_INFORMATIONS = SELF__LAYOUT_INFORMATIONS;

	/**
	 * The number of structural features of the '<em>Super</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUPER_FEATURE_COUNT = SELF_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link tools.mdsd.jamopp.model.java.literals.impl.ThisImpl <em>This</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see tools.mdsd.jamopp.model.java.literals.impl.ThisImpl
	 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getThis()
	 * @generated
	 */
	int THIS = 22;

	/**
	 * The feature id for the '<em><b>Layout Informations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THIS__LAYOUT_INFORMATIONS = SELF__LAYOUT_INFORMATIONS;

	/**
	 * The number of structural features of the '<em>This</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THIS_FEATURE_COUNT = SELF_FEATURE_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.Literal <em>Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.Literal
	 * @generated
	 */
	EClass getLiteral();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.Self <em>Self</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Self</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.Self
	 * @generated
	 */
	EClass getSelf();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.BooleanLiteral <em>Boolean Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Boolean Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.BooleanLiteral
	 * @generated
	 */
	EClass getBooleanLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.BooleanLiteral#isValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.BooleanLiteral#isValue()
	 * @see #getBooleanLiteral()
	 * @generated
	 */
	EAttribute getBooleanLiteral_Value();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.CharacterLiteral <em>Character Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Character Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.CharacterLiteral
	 * @generated
	 */
	EClass getCharacterLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.CharacterLiteral#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.CharacterLiteral#getValue()
	 * @see #getCharacterLiteral()
	 * @generated
	 */
	EAttribute getCharacterLiteral_Value();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.FloatLiteral <em>Float Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Float Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.FloatLiteral
	 * @generated
	 */
	EClass getFloatLiteral();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.DecimalFloatLiteral <em>Decimal Float Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Decimal Float Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.DecimalFloatLiteral
	 * @generated
	 */
	EClass getDecimalFloatLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.DecimalFloatLiteral#getDecimalValue <em>Decimal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Decimal Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.DecimalFloatLiteral#getDecimalValue()
	 * @see #getDecimalFloatLiteral()
	 * @generated
	 */
	EAttribute getDecimalFloatLiteral_DecimalValue();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.HexFloatLiteral <em>Hex Float Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Hex Float Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.HexFloatLiteral
	 * @generated
	 */
	EClass getHexFloatLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.HexFloatLiteral#getHexValue <em>Hex Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hex Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.HexFloatLiteral#getHexValue()
	 * @see #getHexFloatLiteral()
	 * @generated
	 */
	EAttribute getHexFloatLiteral_HexValue();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.DoubleLiteral <em>Double Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Double Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.DoubleLiteral
	 * @generated
	 */
	EClass getDoubleLiteral();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.DecimalDoubleLiteral <em>Decimal Double Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Decimal Double Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.DecimalDoubleLiteral
	 * @generated
	 */
	EClass getDecimalDoubleLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.DecimalDoubleLiteral#getDecimalValue <em>Decimal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Decimal Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.DecimalDoubleLiteral#getDecimalValue()
	 * @see #getDecimalDoubleLiteral()
	 * @generated
	 */
	EAttribute getDecimalDoubleLiteral_DecimalValue();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.HexDoubleLiteral <em>Hex Double Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Hex Double Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.HexDoubleLiteral
	 * @generated
	 */
	EClass getHexDoubleLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.HexDoubleLiteral#getHexValue <em>Hex Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hex Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.HexDoubleLiteral#getHexValue()
	 * @see #getHexDoubleLiteral()
	 * @generated
	 */
	EAttribute getHexDoubleLiteral_HexValue();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.IntegerLiteral <em>Integer Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Integer Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.IntegerLiteral
	 * @generated
	 */
	EClass getIntegerLiteral();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.DecimalIntegerLiteral <em>Decimal Integer Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Decimal Integer Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.DecimalIntegerLiteral
	 * @generated
	 */
	EClass getDecimalIntegerLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.DecimalIntegerLiteral#getDecimalValue <em>Decimal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Decimal Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.DecimalIntegerLiteral#getDecimalValue()
	 * @see #getDecimalIntegerLiteral()
	 * @generated
	 */
	EAttribute getDecimalIntegerLiteral_DecimalValue();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.HexIntegerLiteral <em>Hex Integer Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Hex Integer Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.HexIntegerLiteral
	 * @generated
	 */
	EClass getHexIntegerLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.HexIntegerLiteral#getHexValue <em>Hex Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hex Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.HexIntegerLiteral#getHexValue()
	 * @see #getHexIntegerLiteral()
	 * @generated
	 */
	EAttribute getHexIntegerLiteral_HexValue();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.OctalIntegerLiteral <em>Octal Integer Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Octal Integer Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.OctalIntegerLiteral
	 * @generated
	 */
	EClass getOctalIntegerLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.OctalIntegerLiteral#getOctalValue <em>Octal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Octal Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.OctalIntegerLiteral#getOctalValue()
	 * @see #getOctalIntegerLiteral()
	 * @generated
	 */
	EAttribute getOctalIntegerLiteral_OctalValue();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.BinaryIntegerLiteral <em>Binary Integer Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Binary Integer Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.BinaryIntegerLiteral
	 * @generated
	 */
	EClass getBinaryIntegerLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.BinaryIntegerLiteral#getBinaryValue <em>Binary Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Binary Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.BinaryIntegerLiteral#getBinaryValue()
	 * @see #getBinaryIntegerLiteral()
	 * @generated
	 */
	EAttribute getBinaryIntegerLiteral_BinaryValue();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.LongLiteral <em>Long Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Long Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.LongLiteral
	 * @generated
	 */
	EClass getLongLiteral();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.DecimalLongLiteral <em>Decimal Long Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Decimal Long Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.DecimalLongLiteral
	 * @generated
	 */
	EClass getDecimalLongLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.DecimalLongLiteral#getDecimalValue <em>Decimal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Decimal Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.DecimalLongLiteral#getDecimalValue()
	 * @see #getDecimalLongLiteral()
	 * @generated
	 */
	EAttribute getDecimalLongLiteral_DecimalValue();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.HexLongLiteral <em>Hex Long Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Hex Long Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.HexLongLiteral
	 * @generated
	 */
	EClass getHexLongLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.HexLongLiteral#getHexValue <em>Hex Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hex Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.HexLongLiteral#getHexValue()
	 * @see #getHexLongLiteral()
	 * @generated
	 */
	EAttribute getHexLongLiteral_HexValue();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.OctalLongLiteral <em>Octal Long Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Octal Long Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.OctalLongLiteral
	 * @generated
	 */
	EClass getOctalLongLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.OctalLongLiteral#getOctalValue <em>Octal Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Octal Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.OctalLongLiteral#getOctalValue()
	 * @see #getOctalLongLiteral()
	 * @generated
	 */
	EAttribute getOctalLongLiteral_OctalValue();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.BinaryLongLiteral <em>Binary Long Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Binary Long Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.BinaryLongLiteral
	 * @generated
	 */
	EClass getBinaryLongLiteral();

	/**
	 * Returns the meta object for the attribute '{@link tools.mdsd.jamopp.model.java.literals.BinaryLongLiteral#getBinaryValue <em>Binary Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Binary Value</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.BinaryLongLiteral#getBinaryValue()
	 * @see #getBinaryLongLiteral()
	 * @generated
	 */
	EAttribute getBinaryLongLiteral_BinaryValue();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.NullLiteral <em>Null Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Null Literal</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.NullLiteral
	 * @generated
	 */
	EClass getNullLiteral();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.Super <em>Super</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Super</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.Super
	 * @generated
	 */
	EClass getSuper();

	/**
	 * Returns the meta object for class '{@link tools.mdsd.jamopp.model.java.literals.This <em>This</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>This</em>'.
	 * @see tools.mdsd.jamopp.model.java.literals.This
	 * @generated
	 */
	EClass getThis();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	LiteralsFactory getLiteralsFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals
	{
		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.LiteralImpl <em>Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getLiteral()
		 * @generated
		 */
		EClass LITERAL = eINSTANCE.getLiteral();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.SelfImpl <em>Self</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.SelfImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getSelf()
		 * @generated
		 */
		EClass SELF = eINSTANCE.getSelf();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.BooleanLiteralImpl <em>Boolean Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.BooleanLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getBooleanLiteral()
		 * @generated
		 */
		EClass BOOLEAN_LITERAL = eINSTANCE.getBooleanLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BOOLEAN_LITERAL__VALUE = eINSTANCE.getBooleanLiteral_Value();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.CharacterLiteralImpl <em>Character Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.CharacterLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getCharacterLiteral()
		 * @generated
		 */
		EClass CHARACTER_LITERAL = eINSTANCE.getCharacterLiteral();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHARACTER_LITERAL__VALUE = eINSTANCE.getCharacterLiteral_Value();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.FloatLiteralImpl <em>Float Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.FloatLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getFloatLiteral()
		 * @generated
		 */
		EClass FLOAT_LITERAL = eINSTANCE.getFloatLiteral();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.DecimalFloatLiteralImpl <em>Decimal Float Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.DecimalFloatLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getDecimalFloatLiteral()
		 * @generated
		 */
		EClass DECIMAL_FLOAT_LITERAL = eINSTANCE.getDecimalFloatLiteral();

		/**
		 * The meta object literal for the '<em><b>Decimal Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DECIMAL_FLOAT_LITERAL__DECIMAL_VALUE = eINSTANCE.getDecimalFloatLiteral_DecimalValue();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.HexFloatLiteralImpl <em>Hex Float Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.HexFloatLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getHexFloatLiteral()
		 * @generated
		 */
		EClass HEX_FLOAT_LITERAL = eINSTANCE.getHexFloatLiteral();

		/**
		 * The meta object literal for the '<em><b>Hex Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HEX_FLOAT_LITERAL__HEX_VALUE = eINSTANCE.getHexFloatLiteral_HexValue();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.DoubleLiteralImpl <em>Double Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.DoubleLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getDoubleLiteral()
		 * @generated
		 */
		EClass DOUBLE_LITERAL = eINSTANCE.getDoubleLiteral();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.DecimalDoubleLiteralImpl <em>Decimal Double Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.DecimalDoubleLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getDecimalDoubleLiteral()
		 * @generated
		 */
		EClass DECIMAL_DOUBLE_LITERAL = eINSTANCE.getDecimalDoubleLiteral();

		/**
		 * The meta object literal for the '<em><b>Decimal Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DECIMAL_DOUBLE_LITERAL__DECIMAL_VALUE = eINSTANCE.getDecimalDoubleLiteral_DecimalValue();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.HexDoubleLiteralImpl <em>Hex Double Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.HexDoubleLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getHexDoubleLiteral()
		 * @generated
		 */
		EClass HEX_DOUBLE_LITERAL = eINSTANCE.getHexDoubleLiteral();

		/**
		 * The meta object literal for the '<em><b>Hex Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HEX_DOUBLE_LITERAL__HEX_VALUE = eINSTANCE.getHexDoubleLiteral_HexValue();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.IntegerLiteralImpl <em>Integer Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.IntegerLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getIntegerLiteral()
		 * @generated
		 */
		EClass INTEGER_LITERAL = eINSTANCE.getIntegerLiteral();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.DecimalIntegerLiteralImpl <em>Decimal Integer Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.DecimalIntegerLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getDecimalIntegerLiteral()
		 * @generated
		 */
		EClass DECIMAL_INTEGER_LITERAL = eINSTANCE.getDecimalIntegerLiteral();

		/**
		 * The meta object literal for the '<em><b>Decimal Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DECIMAL_INTEGER_LITERAL__DECIMAL_VALUE = eINSTANCE.getDecimalIntegerLiteral_DecimalValue();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.HexIntegerLiteralImpl <em>Hex Integer Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.HexIntegerLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getHexIntegerLiteral()
		 * @generated
		 */
		EClass HEX_INTEGER_LITERAL = eINSTANCE.getHexIntegerLiteral();

		/**
		 * The meta object literal for the '<em><b>Hex Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HEX_INTEGER_LITERAL__HEX_VALUE = eINSTANCE.getHexIntegerLiteral_HexValue();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.OctalIntegerLiteralImpl <em>Octal Integer Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.OctalIntegerLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getOctalIntegerLiteral()
		 * @generated
		 */
		EClass OCTAL_INTEGER_LITERAL = eINSTANCE.getOctalIntegerLiteral();

		/**
		 * The meta object literal for the '<em><b>Octal Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OCTAL_INTEGER_LITERAL__OCTAL_VALUE = eINSTANCE.getOctalIntegerLiteral_OctalValue();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.BinaryIntegerLiteralImpl <em>Binary Integer Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.BinaryIntegerLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getBinaryIntegerLiteral()
		 * @generated
		 */
		EClass BINARY_INTEGER_LITERAL = eINSTANCE.getBinaryIntegerLiteral();

		/**
		 * The meta object literal for the '<em><b>Binary Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BINARY_INTEGER_LITERAL__BINARY_VALUE = eINSTANCE.getBinaryIntegerLiteral_BinaryValue();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.LongLiteralImpl <em>Long Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LongLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getLongLiteral()
		 * @generated
		 */
		EClass LONG_LITERAL = eINSTANCE.getLongLiteral();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.DecimalLongLiteralImpl <em>Decimal Long Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.DecimalLongLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getDecimalLongLiteral()
		 * @generated
		 */
		EClass DECIMAL_LONG_LITERAL = eINSTANCE.getDecimalLongLiteral();

		/**
		 * The meta object literal for the '<em><b>Decimal Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DECIMAL_LONG_LITERAL__DECIMAL_VALUE = eINSTANCE.getDecimalLongLiteral_DecimalValue();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.HexLongLiteralImpl <em>Hex Long Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.HexLongLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getHexLongLiteral()
		 * @generated
		 */
		EClass HEX_LONG_LITERAL = eINSTANCE.getHexLongLiteral();

		/**
		 * The meta object literal for the '<em><b>Hex Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HEX_LONG_LITERAL__HEX_VALUE = eINSTANCE.getHexLongLiteral_HexValue();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.OctalLongLiteralImpl <em>Octal Long Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.OctalLongLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getOctalLongLiteral()
		 * @generated
		 */
		EClass OCTAL_LONG_LITERAL = eINSTANCE.getOctalLongLiteral();

		/**
		 * The meta object literal for the '<em><b>Octal Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OCTAL_LONG_LITERAL__OCTAL_VALUE = eINSTANCE.getOctalLongLiteral_OctalValue();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.BinaryLongLiteralImpl <em>Binary Long Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.BinaryLongLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getBinaryLongLiteral()
		 * @generated
		 */
		EClass BINARY_LONG_LITERAL = eINSTANCE.getBinaryLongLiteral();

		/**
		 * The meta object literal for the '<em><b>Binary Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BINARY_LONG_LITERAL__BINARY_VALUE = eINSTANCE.getBinaryLongLiteral_BinaryValue();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.NullLiteralImpl <em>Null Literal</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.NullLiteralImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getNullLiteral()
		 * @generated
		 */
		EClass NULL_LITERAL = eINSTANCE.getNullLiteral();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.SuperImpl <em>Super</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.SuperImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getSuper()
		 * @generated
		 */
		EClass SUPER = eINSTANCE.getSuper();

		/**
		 * The meta object literal for the '{@link tools.mdsd.jamopp.model.java.literals.impl.ThisImpl <em>This</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see tools.mdsd.jamopp.model.java.literals.impl.ThisImpl
		 * @see tools.mdsd.jamopp.model.java.literals.impl.LiteralsPackageImpl#getThis()
		 * @generated
		 */
		EClass THIS = eINSTANCE.getThis();

	}

} //LiteralsPackage
