/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.literals;

import java.math.BigInteger;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Octal Long Literal</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link tools.mdsd.jamopp.model.java.literals.OctalLongLiteral#getOctalValue <em>Octal Value</em>}</li>
 * </ul>
 *
 * @see tools.mdsd.jamopp.model.java.literals.LiteralsPackage#getOctalLongLiteral()
 * @model
 * @generated
 */
public interface OctalLongLiteral extends LongLiteral
{
	/**
	 * Returns the value of the '<em><b>Octal Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Octal Value</em>' attribute.
	 * @see #setOctalValue(BigInteger)
	 * @see tools.mdsd.jamopp.model.java.literals.LiteralsPackage#getOctalLongLiteral_OctalValue()
	 * @model required="true"
	 * @generated
	 */
	BigInteger getOctalValue();

	/**
	 * Sets the value of the '{@link tools.mdsd.jamopp.model.java.literals.OctalLongLiteral#getOctalValue <em>Octal Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Octal Value</em>' attribute.
	 * @see #getOctalValue()
	 * @generated
	 */
	void setOctalValue(BigInteger value);

} // OctalLongLiteral
