/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.members;

import org.eclipse.emf.common.util.EList;

import tools.mdsd.jamopp.model.java.instantiations.Initializable;

import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;

import tools.mdsd.jamopp.model.java.references.ReferenceableElement;

import tools.mdsd.jamopp.model.java.variables.Variable;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Field</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link tools.mdsd.jamopp.model.java.members.Field#getAdditionalFields <em>Additional Fields</em>}</li>
 * </ul>
 *
 * @see tools.mdsd.jamopp.model.java.members.MembersPackage#getField()
 * @model
 * @generated
 */
public interface Field extends Member, Initializable, Variable, ReferenceableElement, AnnotableAndModifiable
{
	/**
	 * Returns the value of the '<em><b>Additional Fields</b></em>' containment reference list.
	 * The list contents are of type {@link tools.mdsd.jamopp.model.java.members.AdditionalField}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Additional Fields</em>' containment reference list.
	 * @see tools.mdsd.jamopp.model.java.members.MembersPackage#getField_AdditionalFields()
	 * @model containment="true" resolveProxies="true"
	 * @generated
	 */
	EList<AdditionalField> getAdditionalFields();

} // Field
