/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.parameters;

import tools.mdsd.jamopp.model.java.annotations.Annotable;

import tools.mdsd.jamopp.model.java.literals.This;

import tools.mdsd.jamopp.model.java.types.TypeReference;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Receiver Parameter</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link tools.mdsd.jamopp.model.java.parameters.ReceiverParameter#getOuterTypeReference <em>Outer Type Reference</em>}</li>
 *   <li>{@link tools.mdsd.jamopp.model.java.parameters.ReceiverParameter#getThisReference <em>This Reference</em>}</li>
 * </ul>
 *
 * @see tools.mdsd.jamopp.model.java.parameters.ParametersPackage#getReceiverParameter()
 * @model
 * @generated
 */
public interface ReceiverParameter extends Parameter, Annotable
{
	/**
	 * Returns the value of the '<em><b>Outer Type Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Outer Type Reference</em>' containment reference.
	 * @see #setOuterTypeReference(TypeReference)
	 * @see tools.mdsd.jamopp.model.java.parameters.ParametersPackage#getReceiverParameter_OuterTypeReference()
	 * @model containment="true" resolveProxies="true"
	 * @generated
	 */
	TypeReference getOuterTypeReference();

	/**
	 * Sets the value of the '{@link tools.mdsd.jamopp.model.java.parameters.ReceiverParameter#getOuterTypeReference <em>Outer Type Reference</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Outer Type Reference</em>' containment reference.
	 * @see #getOuterTypeReference()
	 * @generated
	 */
	void setOuterTypeReference(TypeReference value);

	/**
	 * Returns the value of the '<em><b>This Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>This Reference</em>' containment reference.
	 * @see #setThisReference(This)
	 * @see tools.mdsd.jamopp.model.java.parameters.ParametersPackage#getReceiverParameter_ThisReference()
	 * @model containment="true" resolveProxies="true" required="true"
	 * @generated
	 */
	This getThisReference();

	/**
	 * Sets the value of the '{@link tools.mdsd.jamopp.model.java.parameters.ReceiverParameter#getThisReference <em>This Reference</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>This Reference</em>' containment reference.
	 * @see #getThisReference()
	 * @generated
	 */
	void setThisReference(This value);

} // ReceiverParameter
