/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.references;

import tools.mdsd.jamopp.model.java.literals.Self;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Self Reference</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link tools.mdsd.jamopp.model.java.references.SelfReference#getSelf <em>Self</em>}</li>
 * </ul>
 *
 * @see tools.mdsd.jamopp.model.java.references.ReferencesPackage#getSelfReference()
 * @model
 * @generated
 */
public interface SelfReference extends Reference
{
	/**
	 * Returns the value of the '<em><b>Self</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Self</em>' containment reference.
	 * @see #setSelf(Self)
	 * @see tools.mdsd.jamopp.model.java.references.ReferencesPackage#getSelfReference_Self()
	 * @model containment="true" resolveProxies="true" required="true"
	 * @generated
	 */
	Self getSelf();

	/**
	 * Sets the value of the '{@link tools.mdsd.jamopp.model.java.references.SelfReference#getSelf <em>Self</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Self</em>' containment reference.
	 * @see #getSelf()
	 * @generated
	 */
	void setSelf(Self value);

} // SelfReference
