/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.statements;

import org.eclipse.emf.common.util.EList;

import tools.mdsd.jamopp.model.java.expressions.Expression;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>For Loop</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link tools.mdsd.jamopp.model.java.statements.ForLoop#getInit <em>Init</em>}</li>
 *   <li>{@link tools.mdsd.jamopp.model.java.statements.ForLoop#getUpdates <em>Updates</em>}</li>
 * </ul>
 *
 * @see tools.mdsd.jamopp.model.java.statements.StatementsPackage#getForLoop()
 * @model
 * @generated
 */
public interface ForLoop extends Statement, StatementContainer, Conditional
{
	/**
	 * Returns the value of the '<em><b>Init</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Init</em>' containment reference.
	 * @see #setInit(ForLoopInitializer)
	 * @see tools.mdsd.jamopp.model.java.statements.StatementsPackage#getForLoop_Init()
	 * @model containment="true" resolveProxies="true"
	 * @generated
	 */
	ForLoopInitializer getInit();

	/**
	 * Sets the value of the '{@link tools.mdsd.jamopp.model.java.statements.ForLoop#getInit <em>Init</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Init</em>' containment reference.
	 * @see #getInit()
	 * @generated
	 */
	void setInit(ForLoopInitializer value);

	/**
	 * Returns the value of the '<em><b>Updates</b></em>' containment reference list.
	 * The list contents are of type {@link tools.mdsd.jamopp.model.java.expressions.Expression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Updates</em>' containment reference list.
	 * @see tools.mdsd.jamopp.model.java.statements.StatementsPackage#getForLoop_Updates()
	 * @model containment="true" resolveProxies="true"
	 * @generated
	 */
	EList<Expression> getUpdates();

} // ForLoop
