/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.types.impl;

import org.eclipse.emf.ecore.EClass;

import tools.mdsd.jamopp.model.java.classifiers.Classifier;

import tools.mdsd.jamopp.model.java.commons.impl.CommentableImpl;

import tools.mdsd.jamopp.model.java.references.Reference;

import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Type Reference</b></em>'.
 * <!-- end-user-doc -->
 *
 * @generated
 */
public abstract class TypeReferenceImpl extends CommentableImpl implements TypeReference
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeReferenceImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return TypesPackage.Literals.TYPE_REFERENCE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Type getTarget()
	{
		return tools.mdsd.jamopp.model.java.extensions.types.TypeReferenceExtension.getBoundTarget((tools.mdsd.jamopp.model.java.types.TypeReference) this, null);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTarget(final Classifier type)
	{
		tools.mdsd.jamopp.model.java.extensions.types.TypeReferenceExtension.setTarget((tools.mdsd.jamopp.model.java.types.TypeReference) this, (tools.mdsd.jamopp.model.java.classifiers.Classifier) type);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Type getBoundTarget(final Reference reference)
	{
		return tools.mdsd.jamopp.model.java.extensions.types.TypeReferenceExtension.getBoundTarget((tools.mdsd.jamopp.model.java.types.TypeReference) this, (tools.mdsd.jamopp.model.java.references.Reference) reference);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ClassifierReference getPureClassifierReference()
	{
		return tools.mdsd.jamopp.model.java.extensions.types.TypeReferenceExtension.getPureClassifierReference((tools.mdsd.jamopp.model.java.types.TypeReference) this);
	}

} //TypeReferenceImpl
