/**
 * Copyright (c) 2006-2014
 * Software Technology Group, Dresden University of Technology
 * DevBoost GmbH, Berlin, Amtsgericht Charlottenburg, HRB 140026
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Software Technology Group - TU Dresden, Germany;
 *   DevBoost GmbH - Berlin, Germany
 *      - initial API and implementation
 *   Martin Armbruster
 *      - Extension for Java 7-13
 *  
 */
package tools.mdsd.jamopp.model.java.variables;

import org.eclipse.emf.common.util.EList;

import tools.mdsd.jamopp.model.java.instantiations.Initializable;

import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;

import tools.mdsd.jamopp.model.java.statements.ForLoopInitializer;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Local Variable</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link tools.mdsd.jamopp.model.java.variables.LocalVariable#getAdditionalLocalVariables <em>Additional Local Variables</em>}</li>
 * </ul>
 *
 * @see tools.mdsd.jamopp.model.java.variables.VariablesPackage#getLocalVariable()
 * @model
 * @generated
 */
public interface LocalVariable extends Variable, Initializable, ForLoopInitializer, AnnotableAndModifiable, Resource
{
	/**
	 * Returns the value of the '<em><b>Additional Local Variables</b></em>' containment reference list.
	 * The list contents are of type {@link tools.mdsd.jamopp.model.java.variables.AdditionalLocalVariable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Additional Local Variables</em>' containment reference list.
	 * @see tools.mdsd.jamopp.model.java.variables.VariablesPackage#getLocalVariable_AdditionalLocalVariables()
	 * @model containment="true" resolveProxies="true"
	 * @generated
	 */
	EList<AdditionalLocalVariable> getAdditionalLocalVariables();

} // LocalVariable
