/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.containers.Package;

public final class JavaClasspath {
    private static JavaClasspath globalClasspath = new JavaClasspath();
    private final Set<Module> modules = new HashSet<Module>();
    private final Set<Package> packages = new HashSet<Package>();
    private final Set<ConcreteClassifier> classifiers = new HashSet<ConcreteClassifier>();

    private JavaClasspath() {
    }

    public static JavaClasspath get() {
        return globalClasspath;
    }

    public void clear() {
        this.modules.clear();
        this.packages.clear();
        this.classifiers.clear();
    }

    public void registerPackage(Package pack) {
        this.packages.add(pack);
    }

    public void registerModule(Module module) {
        this.modules.add(module);
    }

    public void registerConcreteClassifier(ConcreteClassifier classifier) {
        this.classifiers.add(classifier);
    }

    public Package getPackage(String packageName) {
        return this.packages.stream().filter(p -> p.getNamespacesAsString().equals(packageName)).findFirst().orElse(null);
    }

    public Module getModule(String moduleName) {
        return this.modules.stream().filter(m -> m.getNamespacesAsString().equals(moduleName)).findFirst().orElse(null);
    }

    public ConcreteClassifier getConcreteClassifier(URI uri) {
        return this.classifiers.stream().filter(c -> c.eResource() != null && c.eResource().getURI().toString().equals(uri.toString())).findFirst().orElse(null);
    }

    public ConcreteClassifier getConcreteClassifier(String fullQualifiedClassifierName) {
        return this.classifiers.stream().filter(c -> c.getQualifiedName().equals(fullQualifiedClassifierName)).findFirst().orElse(null);
    }

    public ConcreteClassifier getFirstConcreteClassifier(String simpleClassifierName) {
        return this.classifiers.stream().filter(c -> c.getName().equals(simpleClassifierName)).findFirst().orElse(null);
    }

    public CompilationUnit getCompilationUnit(String fullQualifiedClassifierName) {
        ConcreteClassifier classifier = this.getConcreteClassifier(fullQualifiedClassifierName);
        CompilationUnit result = null;
        if (classifier != null) {
            while (classifier.eContainer() != null && !(classifier.eContainer() instanceof CompilationUnit)) {
                classifier = (ConcreteClassifier)classifier.eContainer();
            }
            if (classifier.eContainer() != null) {
                result = (CompilationUnit)classifier.eContainer();
            }
        }
        return result;
    }

    public Resource getResource(URI resourceURI) {
        ConcreteClassifier classifier = this.getConcreteClassifier(resourceURI);
        Package pack = this.packages.stream().filter(p -> p.eResource() != null).filter(p -> p.eResource().getURI().toString().equals(resourceURI.toString())).findFirst().orElse(null);
        Module mod = this.modules.stream().filter(m -> m.eResource() != null).filter(m -> m.eResource().getURI().toString().equals(resourceURI.toString())).findFirst().orElse(null);
        Resource result = null;
        if (classifier != null) {
            result = classifier.eResource();
        } else if (pack != null) {
            result = pack.eResource();
        } else if (mod != null) {
            result = mod.eResource();
        }
        return result;
    }
}

