/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.classifiers;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.instantiations.NewConstructorCall;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;

public final class AnonymousClassExtension {
    private AnonymousClassExtension() {
    }

    public static EList<Member> getAllMembers(AnonymousClass anonymousClass, Commentable context) {
        TypeReference typeReference;
        Type target;
        ConcreteClassifier classifier;
        UniqueEList memberList = new UniqueEList();
        memberList.addAll((Collection)anonymousClass.getMembers());
        memberList.addAll((Collection)anonymousClass.getDefaultMembers());
        NewConstructorCall ncCall = null;
        EObject eContainer = anonymousClass.eContainer();
        if (eContainer instanceof NewConstructorCall) {
            ncCall = (NewConstructorCall)eContainer;
        }
        if (ncCall != null && (classifier = (ConcreteClassifier)(target = (typeReference = ncCall.getTypeReference()).getTarget())) != null) {
            EList<Member> superMemberList = classifier.getAllMembers(context);
            for (Member superMember : superMemberList) {
                AnonymousClassExtension.addToList(anonymousClass, context, (EList<Member>)memberList, superMember);
            }
        }
        return memberList;
    }

    private static void addToList(AnonymousClass anonymousClass, Commentable context, EList<Member> memberList, Member superMember) {
        Member newMember = superMember;
        if (newMember instanceof AnnotableAndModifiable) {
            AnnotableAndModifiable modifiable;
            if (newMember.eIsProxy()) {
                newMember = (Member)EcoreUtil.resolve((EObject)newMember, (EObject)anonymousClass);
            }
            if (!(modifiable = (AnnotableAndModifiable)((Object)newMember)).isHidden(context)) {
                memberList.add((Object)newMember);
            }
        } else {
            memberList.add((Object)newMember);
        }
    }

    public static EList<ConcreteClassifier> getAllSuperClassifiers(AnonymousClass anonymousClass) {
        UniqueEList superClassifierList = new UniqueEList();
        ConcreteClassifier superClassifier = anonymousClass.getSuperClassifier();
        if (superClassifier != null) {
            superClassifierList.add((Object)superClassifier);
            superClassifierList.addAll(superClassifier.getAllSuperClassifiers());
        } else {
            superClassifierList.add((Object)anonymousClass.getObjectClass());
        }
        return superClassifierList;
    }

    public static ConcreteClassifier getSuperClassifier(EObject eObject) {
        EObject eContainer = eObject.eContainer();
        ConcreteClassifier result = null;
        if (eContainer instanceof NewConstructorCall) {
            NewConstructorCall ncCall = (NewConstructorCall)eContainer;
            TypeReference typeReference = ncCall.getTypeReference();
            Type target = typeReference.getTarget();
            result = (ConcreteClassifier)target;
        } else if (eContainer instanceof EnumConstant && eContainer.eContainer() instanceof Enumeration) {
            result = (Enumeration)eContainer.eContainer();
        }
        return result;
    }
}

