/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.classifiers;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.types.PrimitiveType;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;

public final class ClassExtension {
    private static final Map<String, Supplier<PrimitiveType>> MAPPINGS = new HashMap<String, Supplier<PrimitiveType>>();

    static {
        MAPPINGS.put("Boolean", () -> TypesFactory.eINSTANCE.createBoolean());
        MAPPINGS.put("Byte", () -> TypesFactory.eINSTANCE.createByte());
        MAPPINGS.put("Character", () -> TypesFactory.eINSTANCE.createChar());
        MAPPINGS.put("Float", () -> TypesFactory.eINSTANCE.createFloat());
        MAPPINGS.put("Double", () -> TypesFactory.eINSTANCE.createDouble());
        MAPPINGS.put("Integer", () -> TypesFactory.eINSTANCE.createInt());
        MAPPINGS.put("Long", () -> TypesFactory.eINSTANCE.createLong());
        MAPPINGS.put("Short", () -> TypesFactory.eINSTANCE.createShort());
        MAPPINGS.put("Void", () -> TypesFactory.eINSTANCE.createVoid());
    }

    private ClassExtension() {
    }

    public static EList<ConcreteClassifier> getAllSuperClassifiers(Class clazz) {
        UniqueEList result = new UniqueEList();
        Class superClass = clazz;
        while (superClass != null && !superClass.eIsProxy() && !clazz.isJavaLangObject(superClass)) {
            if ((superClass = superClass.getSuperClass()) == null) continue;
            result.add((Object)superClass);
        }
        ClassExtension.collectAllImplementedInterfaces(clazz, (EList<ConcreteClassifier>)result);
        ClassExtension.collectImplementedInterfacesOfSuperClass(clazz, (EList<ConcreteClassifier>)result);
        return result;
    }

    private static void collectImplementedInterfacesOfSuperClass(Class clazz, EList<ConcreteClassifier> result) {
        Class superClass = clazz.getSuperClass();
        if (superClass != null && !superClass.eIsProxy() && !clazz.isJavaLangObject(superClass)) {
            result.addAll(superClass.getAllSuperClassifiers());
        }
    }

    private static void collectAllImplementedInterfaces(Class clazz, EList<ConcreteClassifier> result) {
        for (TypeReference typeArg : clazz.getImplements()) {
            ConcreteClassifier superInterface = (ConcreteClassifier)typeArg.getTarget();
            if (superInterface == null) continue;
            result.add((Object)superInterface);
            if (!(superInterface instanceof Interface)) continue;
            result.addAll(((Interface)superInterface).getAllSuperClassifiers());
        }
    }

    public static Class getSuperClass(Class clazz) {
        Type target;
        TypeReference superClassReference = clazz.getExtends();
        if (superClassReference == null) {
            superClassReference = clazz.getDefaultExtends();
        }
        Class result = null;
        if (superClassReference != null && (target = superClassReference.getTarget()) instanceof Class) {
            result = (Class)target;
        }
        return result;
    }

    public static PrimitiveType unWrapPrimitiveType(Class clazz) {
        PrimitiveType result = null;
        for (Map.Entry<String, Supplier<PrimitiveType>> entry : MAPPINGS.entrySet()) {
            String key = entry.getKey();
            Supplier<PrimitiveType> val = entry.getValue();
            if (!clazz.getLibClass(key).equals(clazz)) continue;
            result = val.get();
            break;
        }
        return result;
    }
}

