/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.classifiers;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;

public final class ConcreteClassifierExtension {
    private static final String OBJECT = "Object";

    private ConcreteClassifierExtension() {
    }

    public static EList<ConcreteClassifier> getAllInnerClassifiers(ConcreteClassifier concreteClassifier) {
        UniqueEList innerClassifierList = new UniqueEList();
        innerClassifierList.addAll(concreteClassifier.getInnerClassifiers());
        for (ConcreteClassifier superClassifier : concreteClassifier.getAllSuperClassifiers()) {
            EList<ConcreteClassifier> superInnerList = superClassifier.getInnerClassifiers();
            for (ConcreteClassifier superInner : superInnerList) {
                boolean isVisible;
                ConcreteClassifier newSuperInner = superInner;
                if (newSuperInner.eIsProxy()) {
                    EObject resolved = EcoreUtil.resolve((EObject)newSuperInner, (EObject)concreteClassifier);
                    newSuperInner = (ConcreteClassifier)resolved;
                }
                boolean bl = isVisible = !newSuperInner.isHidden(concreteClassifier);
                if (!isVisible) continue;
                innerClassifierList.add((Object)newSuperInner);
            }
        }
        return innerClassifierList;
    }

    public static EList<ConcreteClassifier> getInnerClassifiers(ConcreteClassifier concreteClassifier) {
        EList<ConcreteClassifier> result;
        if (concreteClassifier.eIsProxy()) {
            result = ECollections.emptyEList();
        } else {
            StringBuilder suffix = new StringBuilder();
            ConcreteClassifier containingClass = concreteClassifier;
            while (containingClass.eContainer() instanceof ConcreteClassifier) {
                containingClass = (ConcreteClassifier)containingClass.eContainer();
                suffix.insert(0, '.').insert(0, containingClass.getName());
            }
            if (containingClass.eContainer() instanceof CompilationUnit) {
                CompilationUnit compilationUnit = (CompilationUnit)containingClass.eContainer();
                String fullName = String.valueOf(compilationUnit.getNamespacesAsString()) + suffix + concreteClassifier.getName();
                result = concreteClassifier.getConcreteClassifiers(fullName, "*");
            } else {
                result = ConcreteClassifierExtension.handleClassedDeclaredInsideMethods(concreteClassifier);
            }
        }
        return result;
    }

    private static EList<ConcreteClassifier> handleClassedDeclaredInsideMethods(ConcreteClassifier concreteClassifier) {
        UniqueEList result = new UniqueEList();
        for (Member member : concreteClassifier.getMembers()) {
            if (!(member instanceof ConcreteClassifier)) continue;
            result.add((Object)((ConcreteClassifier)member));
        }
        for (ConcreteClassifier superClassifier : concreteClassifier.getAllSuperClassifiers()) {
            for (Member member : superClassifier.getMembers()) {
                if (!(member instanceof ConcreteClassifier)) continue;
                result.add((Object)((ConcreteClassifier)member));
            }
        }
        return result;
    }

    public static EList<ClassifierReference> getSuperTypeReferences(ConcreteClassifier concreteClassifier) {
        UniqueEList typeReferenceList = new UniqueEList();
        ConcreteClassifier concreteClassifier2 = concreteClassifier;
        if (concreteClassifier2 instanceof Class && (var2_3 = (Class)concreteClassifier2) == (Class)var3_2) {
            TypeReference superClass = javaClass.getExtends();
            if (superClass != null) {
                ClassifierReference classifierReference = superClass.getPureClassifierReference();
                typeReferenceList.add((Object)classifierReference);
                Classifier target = classifierReference.getTarget();
                ConcreteClassifier concreteTarget = (ConcreteClassifier)target;
                if (!concreteClassifier.isJavaLangObject(concreteTarget)) {
                    typeReferenceList.addAll(concreteTarget.getSuperTypeReferences());
                }
            }
            ConcreteClassifierExtension.addSuperTypes((List<TypeReference>)javaClass.getImplements(), (List<ClassifierReference>)typeReferenceList);
        } else {
            if (concreteClassifier instanceof Interface superClass) {
                ConcreteClassifierExtension.addSuperTypes(javaInterface.getExtends(), (List<ClassifierReference>)typeReferenceList);
            }
        }
        return typeReferenceList;
    }

    private static void addSuperTypes(List<TypeReference> typeReferences, List<ClassifierReference> superTypeReferences) {
        for (TypeReference interfaceReference : typeReferences) {
            ConcreteClassifierExtension.addSuperType(interfaceReference, superTypeReferences);
        }
    }

    private static void addSuperType(TypeReference typeReference, List<ClassifierReference> superTypeReferences) {
        ClassifierReference classifierReference = typeReference.getPureClassifierReference();
        superTypeReferences.add(classifierReference);
        Classifier target = classifierReference.getTarget();
        ConcreteClassifier concreteTarget = (ConcreteClassifier)target;
        superTypeReferences.addAll((Collection<ClassifierReference>)concreteTarget.getSuperTypeReferences());
    }

    public static EList<Member> getAllMembers(ConcreteClassifier classifier, Commentable context) {
        UniqueEList memberList = new UniqueEList();
        ConcreteClassifier concreteClassifier = classifier;
        memberList.addAll((Collection)concreteClassifier.getMembers());
        memberList.addAll((Collection)concreteClassifier.getDefaultMembers());
        memberList.addAll(concreteClassifier.getAllInnerClassifiers());
        for (ConcreteClassifier superClassifier : classifier.getAllSuperClassifiers()) {
            for (Member member : superClassifier.getMembers()) {
                if (member instanceof AnnotableAndModifiable var8_8) {
                    boolean bl = isVisible = !modifiable.isHidden(context);
                    if (!isVisible) continue;
                    memberList.add((Object)member);
                    continue;
                }
                memberList.add((Object)member);
            }
            memberList.addAll((Collection)superClassifier.getDefaultMembers());
        }
        return memberList;
    }

    public static String getQualifiedName(ConcreteClassifier concreteClassifier) {
        StringBuilder qualifiedName = new StringBuilder();
        if (concreteClassifier.eContainer() instanceof ConcreteClassifier) {
            qualifiedName.append(((ConcreteClassifier)concreteClassifier.eContainer()).getQualifiedName());
            qualifiedName.append('.');
        } else {
            EList<String> packageParts = concreteClassifier.getContainingPackageName();
            if (packageParts != null) {
                for (String packagePart : packageParts) {
                    qualifiedName.append(packagePart);
                    qualifiedName.append('.');
                }
            }
        }
        qualifiedName.append(concreteClassifier.getName());
        return qualifiedName.toString();
    }

    public static boolean isJavaLangObject(ConcreteClassifier clazz) {
        EList<String> packageName;
        String name = clazz.getName();
        boolean result = OBJECT.equals(name) ? (packageName = clazz.getContainingPackageName()).size() != 2 || !"java".equals(packageName.get(0)) || !"lang".equals(packageName.get(1)) : false;
        return result;
    }
}

