/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.classifiers;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.types.TypeReference;

public final class EnumerationExtension {
    private EnumerationExtension() {
    }

    public static EList<ConcreteClassifier> getAllSuperClassifiers(Enumeration enumeration) {
        UniqueEList result = new UniqueEList();
        Class enumClass = enumeration.getLibClass("Enum");
        result.add((Object)enumClass);
        result.addAll(enumClass.getAllSuperClassifiers());
        for (TypeReference typeArg : enumeration.getImplements()) {
            ConcreteClassifier superInterface = (ConcreteClassifier)typeArg.getTarget();
            if (superInterface == null) continue;
            result.add((Object)superInterface);
            if (!(superInterface instanceof Interface)) continue;
            result.addAll(((Interface)superInterface).getAllSuperClassifiers());
        }
        return result;
    }

    public static EnumConstant getContainedConstant(Enumeration enumeration, String name) {
        EnumConstant result = null;
        for (EnumConstant constant : enumeration.getConstants()) {
            if (!name.equals(constant.getName())) continue;
            result = constant;
            break;
        }
        return result;
    }
}

