/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.commons;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementListContainer;

public final class CommentableExtension {
    private static final char DOLLAR = '$';

    private CommentableExtension() {
    }

    public static void addBeforeContainingStatement(Commentable commentable, Statement statementToAdd) {
        EObject container = commentable.eContainer();
        Commentable statement = commentable;
        while (container != null) {
            if (container instanceof StatementListContainer) break;
            container = container.eContainer();
            statement = statement.eContainer();
        }
        if (container == null) {
            throw new IllegalArgumentException("Element " + commentable + " is not contained in a StatementListContainer.");
        }
        StatementListContainer statementListContainer = (StatementListContainer)container;
        EList<Statement> statements = statementListContainer.getStatements();
        int index = statements.indexOf((Object)statement);
        statements.add(index, (Object)statementToAdd);
    }

    public static void addAfterContainingStatement(Commentable commentable, Statement statementToAdd) {
        EObject container = commentable.eContainer();
        Commentable statement = commentable;
        while (container != null) {
            if (container instanceof StatementListContainer) break;
            container = container.eContainer();
            statement = statement.eContainer();
        }
        if (container == null) {
            throw new IllegalArgumentException("Element " + commentable + " is not contained in a StatementListContainer.");
        }
        StatementListContainer statementListContainer = (StatementListContainer)container;
        EList<Statement> statements = statementListContainer.getStatements();
        int index = statements.indexOf((Object)statement);
        if (index == statements.size() - 1) {
            statements.add((Object)statementToAdd);
        } else {
            statements.add(index + 1, (Object)statementToAdd);
        }
    }

    public static EObject getParentByEType(EObject eObject, EClassifier type) {
        EObject container = eObject.eContainer();
        EObject result = null;
        while (container != null) {
            if (type.isInstance((Object)container)) {
                result = container;
                break;
            }
            container = container.eContainer();
        }
        return result;
    }

    public static <T> T getParentByType(EObject eObject, Class<T> type) {
        EObject container = eObject.eContainer();
        T result = null;
        while (container != null) {
            if (type.isInstance(container)) {
                result = type.cast(container);
                break;
            }
            container = container.eContainer();
        }
        return result;
    }

    public static EObject getFirstChildByEType(EObject eObject, EClassifier type) {
        TreeIterator iterator = eObject.eAllContents();
        EObject result = null;
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            if (!type.isInstance((Object)next)) continue;
            result = next;
            break;
        }
        return result;
    }

    public static <T> T getFirstChildByType(EObject eObject, Class<T> type) {
        TreeIterator iterator = eObject.eAllContents();
        T result = null;
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            if (!type.isInstance(next)) continue;
            result = type.cast(next);
            break;
        }
        return result;
    }

    public static EList<EObject> getChildrenByEType(EObject eObject, EClassifier type) {
        BasicEList children = new BasicEList();
        TreeIterator iterator = eObject.eAllContents();
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            if (!type.isInstance((Object)next)) continue;
            children.add((Object)next);
        }
        return children;
    }

    public static <T> EList<T> getChildrenByType(EObject eObject, Class<T> type) {
        BasicEList children = new BasicEList();
        TreeIterator iterator = eObject.eAllContents();
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            if (!type.isInstance(next)) continue;
            children.add(type.cast(next));
        }
        return children;
    }

    public static ConcreteClassifier getConcreteClassifier(Commentable commentable, String name) {
        return JavaClasspath.get().getFirstConcreteClassifier(name);
    }

    public static EList<ConcreteClassifier> getConcreteClassifiers(Commentable commentable, String packageName, String classifierQuery) {
        UniqueEList result = new UniqueEList();
        if ("*".equals(classifierQuery)) {
            Package pack = JavaClasspath.get().getPackage(packageName);
            if (pack != null) {
                result.addAll(pack.getClassifiers());
            }
        } else {
            ConcreteClassifier classifier = JavaClasspath.get().getConcreteClassifier(String.valueOf(packageName) + "." + classifierQuery);
            if (classifier != null) {
                result.add((Object)classifier);
            }
        }
        return result;
    }

    public static tools.mdsd.jamopp.model.java.classifiers.Class getLibClass(Commentable commentable, String name) {
        ConcreteClassifier result = JavaClasspath.get().getConcreteClassifier("java.lang." + name);
        tools.mdsd.jamopp.model.java.classifiers.Class resultClass = null;
        if (result instanceof tools.mdsd.jamopp.model.java.classifiers.Class) {
            resultClass = (tools.mdsd.jamopp.model.java.classifiers.Class)result;
        }
        return resultClass;
    }

    public static Interface getLibInterface(Commentable commentable, String name) {
        ConcreteClassifier interfaceClass = JavaClasspath.get().getConcreteClassifier("java.lang." + name);
        Interface result = null;
        if (interfaceClass instanceof Interface) {
            result = (Interface)interfaceClass;
        }
        return result;
    }

    public static tools.mdsd.jamopp.model.java.classifiers.Class getClassClass(Commentable commentabke) {
        return commentabke.getLibClass("Class");
    }

    public static tools.mdsd.jamopp.model.java.classifiers.Class getObjectClass(Commentable commentable) {
        return commentable.getLibClass("Object");
    }

    public static tools.mdsd.jamopp.model.java.classifiers.Class getStringClass(Commentable commentable) {
        return commentable.getLibClass("String");
    }

    public static Interface getAnnotationInterface(Commentable commentable) {
        ConcreteClassifier proxy = JavaClasspath.get().getConcreteClassifier("java.lang.annotation.Annotation");
        Interface result = null;
        if (proxy instanceof Interface) {
            result = (Interface)proxy;
        }
        return result;
    }

    public static ConcreteClassifier getContainingConcreteClassifier(Commentable commentable) {
        Commentable value = commentable;
        while (!(value instanceof ConcreteClassifier) && value != null) {
            value = value.eContainer();
        }
        return (ConcreteClassifier)value;
    }

    public static ConcreteClassifier getParentConcreteClassifier(Commentable commentable) {
        return commentable.getContainingConcreteClassifier();
    }

    public static AnonymousClass getContainingAnonymousClass(Commentable commentable) {
        Commentable value = commentable;
        while (!(value instanceof AnonymousClass) && !(value instanceof ConcreteClassifier) && value != null) {
            value = value.eContainer();
        }
        AnonymousClass result = null;
        if (value instanceof AnonymousClass) {
            result = (AnonymousClass)value;
        }
        return result;
    }

    public static CompilationUnit getContainingCompilationUnit(Commentable commentable) {
        Commentable value = commentable;
        while (!(value instanceof CompilationUnit) && value != null) {
            value = value.eContainer();
        }
        return (CompilationUnit)value;
    }

    public static AnnotationInstance getContainingAnnotationInstance(Commentable commentable) {
        Commentable value = commentable;
        while (!(value instanceof AnnotationInstance) && value != null) {
            value = value.eContainer();
        }
        return (AnnotationInstance)value;
    }

    public static EList<String> getContainingPackageName(Commentable commentable) {
        EList result;
        CompilationUnit compilationUnit = commentable.getContainingCompilationUnit();
        if (compilationUnit == null) {
            result = ECollections.emptyEList();
        } else {
            int idx = compilationUnit.getNamespaces().size();
            if (compilationUnit.getName() != null) {
                char[] fullName;
                char[] cArray = fullName = compilationUnit.getName().toCharArray();
                int n = fullName.length;
                int n2 = 0;
                while (n2 < n) {
                    char element = cArray[n2];
                    if (element == '$') {
                        --idx;
                    }
                    ++n2;
                }
            }
            List packageNameParts = compilationUnit.getNamespaces().subList(0, idx);
            BasicEList packageNameList = new BasicEList((Collection)packageNameParts);
            result = ECollections.unmodifiableEList((EList)packageNameList);
        }
        return result;
    }

    public static EList<String> getContainingContainerName(Commentable commentable) {
        CompilationUnit compilationUnit = commentable.getContainingCompilationUnit();
        EList result = compilationUnit == null ? ECollections.emptyEList() : ECollections.unmodifiableEList((EList)compilationUnit.getNamespaces());
        return result;
    }
}

