/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.containers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;
import tools.mdsd.jamopp.model.java.imports.ClassifierImport;
import tools.mdsd.jamopp.model.java.imports.ImportsFactory;
import tools.mdsd.jamopp.model.java.imports.PackageImport;

public final class CompilationUnitExtension {
    private CompilationUnitExtension() {
    }

    public static ConcreteClassifier getContainedClassifier(CompilationUnit compilationUnit, String name) {
        ConcreteClassifier result = null;
        for (ConcreteClassifier candidate : compilationUnit.getClassifiers()) {
            if (!name.equals(candidate.getName())) continue;
            result = candidate;
        }
        return result;
    }

    public static EList<ConcreteClassifier> getClassifiersInSamePackage(CompilationUnit compilationUnit) {
        UniqueEList defaultImportList = new UniqueEList();
        String packageName = compilationUnit.getNamespacesAsString();
        defaultImportList.addAll(compilationUnit.getClassifiers());
        defaultImportList.addAll(compilationUnit.getConcreteClassifiers(packageName, "*"));
        return defaultImportList;
    }

    /*
     * WARNING - void declaration
     */
    public static Class getContainedClass(CompilationUnit compilationUnit) {
        EList<ConcreteClassifier> classifiers = compilationUnit.getClassifiers();
        Class result = null;
        Object e = classifiers.get(0);
        if (e instanceof Class var3_4 && classifiers.size() == 1) {
            void clazz;
            result = clazz;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Interface getContainedInterface(CompilationUnit compilationUnit) {
        EList<ConcreteClassifier> classifiers = compilationUnit.getClassifiers();
        Interface result = null;
        Object e = classifiers.get(0);
        if (e instanceof Interface var3_4 && classifiers.size() == 1) {
            void interfaze;
            result = interfaze;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Annotation getContainedAnnotation(CompilationUnit compilationUnit) {
        EList<ConcreteClassifier> classifiers = compilationUnit.getClassifiers();
        Annotation result = null;
        Object e = classifiers.get(0);
        if (e instanceof Annotation var3_4 && classifiers.size() == 1) {
            void annotation;
            result = annotation;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Enumeration getContainedEnumeration(CompilationUnit compilationUnit) {
        EList<ConcreteClassifier> classifiers = compilationUnit.getClassifiers();
        Enumeration result = null;
        Object e = classifiers.get(0);
        if (e instanceof Enumeration var3_4 && classifiers.size() == 1) {
            void enumeration;
            result = enumeration;
        }
        return result;
    }

    public static void addImport(CompilationUnit compilationUnit, String nameOfClassToImport) {
        ClassifierImport classifierImport = ImportsFactory.eINSTANCE.createClassifierImport();
        ConcreteClassifier classToImport = compilationUnit.getConcreteClassifier(nameOfClassToImport);
        classifierImport.setClassifier(classToImport);
        classifierImport.getNamespaces().addAll((Collection)classToImport.getContainingCompilationUnit().getNamespaces());
        compilationUnit.getImports().add((Object)classifierImport);
    }

    public static void addPackageImport(CompilationUnit compilationUnit, String packageName) {
        PackageImport nsImport = ImportsFactory.eINSTANCE.createPackageImport();
        Collections.addAll(nsImport.getNamespaces(), packageName.split("\\."));
        compilationUnit.getImports().add((Object)nsImport);
    }
}

