/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.expressions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.arrays.ArrayInstantiationBySize;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.expressions.AdditiveExpression;
import tools.mdsd.jamopp.model.java.expressions.AndExpression;
import tools.mdsd.jamopp.model.java.expressions.AssignmentExpression;
import tools.mdsd.jamopp.model.java.expressions.CastExpression;
import tools.mdsd.jamopp.model.java.expressions.ConditionalAndExpression;
import tools.mdsd.jamopp.model.java.expressions.ConditionalExpression;
import tools.mdsd.jamopp.model.java.expressions.ConditionalOrExpression;
import tools.mdsd.jamopp.model.java.expressions.EqualityExpression;
import tools.mdsd.jamopp.model.java.expressions.ExclusiveOrExpression;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.expressions.InclusiveOrExpression;
import tools.mdsd.jamopp.model.java.expressions.InstanceOfExpression;
import tools.mdsd.jamopp.model.java.expressions.MultiplicativeExpression;
import tools.mdsd.jamopp.model.java.expressions.NestedExpression;
import tools.mdsd.jamopp.model.java.expressions.PrimaryExpression;
import tools.mdsd.jamopp.model.java.expressions.RelationExpression;
import tools.mdsd.jamopp.model.java.expressions.ShiftExpression;
import tools.mdsd.jamopp.model.java.expressions.UnaryExpression;
import tools.mdsd.jamopp.model.java.expressions.UnaryExpressionChild;
import tools.mdsd.jamopp.model.java.literals.Literal;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.model.java.references.ElementReference;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.variables.AdditionalLocalVariable;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;

public final class ExpressionExtension {
    private static final String CLONE = "clone";

    private ExpressionExtension() {
    }

    public static Type getType(Expression expression) {
        return expression.getOneType(false);
    }

    public static Type getAlternativeType(Expression expression) {
        return expression.getOneType(true);
    }

    public static Type getOneType(Expression expression, boolean alternative) {
        Class stringClass = expression.getStringClass();
        Type type = null;
        if (expression instanceof Reference var4_5) {
            while (reference.getNext() != null) {
                reference = reference.getNext();
            }
            type = reference.getReferencedType();
        } else if (expression instanceof Literal) {
            type = ((Literal)expression).getType();
        } else if (expression instanceof CastExpression) {
            type = ((CastExpression)expression).getTypeReference().getTarget();
        } else if (expression instanceof AssignmentExpression) {
            type = ((AssignmentExpression)expression).getChild().getOneType(alternative);
        } else if (expression instanceof ConditionalExpression && ((ConditionalExpression)expression).getExpressionIf() != null) {
            type = alternative ? ((ConditionalExpression)expression).getExpressionElse().getOneType(alternative) : ((ConditionalExpression)expression).getExpressionIf().getOneType(alternative);
        } else if (expression instanceof EqualityExpression || expression instanceof RelationExpression || expression instanceof ConditionalOrExpression || expression instanceof ConditionalAndExpression || expression instanceof InstanceOfExpression) {
            type = expression.getLibClass("Boolean");
        } else {
            if (expression instanceof AdditiveExpression || expression instanceof MultiplicativeExpression || expression instanceof InclusiveOrExpression || expression instanceof ExclusiveOrExpression || expression instanceof AndExpression || expression instanceof ShiftExpression) {
                if (expression instanceof AdditiveExpression var6_8) {
                    for (Expression subExp : additiveExpression.getChildren()) {
                        if (!stringClass.equals(subExp.getOneType(alternative))) continue;
                        return stringClass;
                    }
                }
                subExp = (Expression)((EList)expression.eGet(expression.eClass().getEStructuralFeature("children"))).get(0);
                return subExp.getOneType(alternative);
            }
            if (expression instanceof UnaryExpression) {
                UnaryExpressionChild subExp = ((UnaryExpression)expression).getChild();
                return subExp.getOneType(alternative);
            }
            TreeIterator i = expression.eAllContents();
            while (i.hasNext()) {
                EObject next = (EObject)i.next();
                Type nextType = null;
                if (next instanceof PrimaryExpression) {
                    if (next instanceof Reference var9_12) {
                        while (ref.getNext() != null) {
                            ref = ref.getNext();
                        }
                        next = ref;
                    }
                    nextType = next instanceof Literal ? ((Literal)next).getType() : (next instanceof CastExpression ? ((CastExpression)next).getTypeReference().getTarget() : ((Reference)next).getReferencedType());
                    i.prune();
                }
                if (nextType != null && stringClass.equals(type = nextType)) break;
            }
        }
        return type;
    }

    public static long getArrayDimension(Expression expression) {
        Expression value;
        long result = expression instanceof NestedExpression && ((NestedExpression)expression).getNext() == null ? ((NestedExpression)expression).getExpression().getArrayDimension() - (long)((NestedExpression)expression).getArraySelectors().size() : (expression instanceof ConditionalExpression && ((ConditionalExpression)expression).getExpressionIf() != null ? ((ConditionalExpression)expression).getExpressionIf().getArrayDimension() : (expression instanceof AssignmentExpression ? ((value = ((AssignmentExpression)expression).getValue()) == null ? 0L : value.getArrayDimension()) : (expression instanceof InstanceOfExpression ? 0L : ExpressionExtension.calcSize(expression))));
        return result;
    }

    private static long calcSize(Expression expression) {
        long size = 0L;
        ArrayTypeable arrayType = null;
        if (expression instanceof Reference var4_4) {
            while (reference.getNext() != null) {
                reference = reference.getNext();
            }
            if (reference instanceof ElementReference && reference.getPrevious() != null && (target = ((ElementReference)reference).getTarget()) instanceof Method && CLONE.equals(((Method)target).getName())) {
                reference = (Reference)reference.eContainer();
            }
            if (( instanceOfPatternExpressionValue = reference) instanceof ElementReference && (target = (ElementReference) instanceOfPatternExpressionValue) == (ElementReference) instanceOfPatternExpressionValue) {
                if (elementReference.getTarget() instanceof ArrayTypeable) {
                    arrayType = (ArrayTypeable)((Object)elementReference.getTarget());
                }
                if (elementReference.getTarget() instanceof AdditionalLocalVariable) {
                    AdditionalLocalVariable additionalLocalVariable = (AdditionalLocalVariable)elementReference.getTarget();
                    arrayType = (LocalVariable)additionalLocalVariable.eContainer();
                    size += (long)additionalLocalVariable.getArrayDimensionsAfter().size();
                    size -= (long)arrayType.getArrayDimensionsAfter().size();
                }
                if (elementReference.getTarget() instanceof AdditionalField) {
                    AdditionalField additionalField = (AdditionalField)elementReference.getTarget();
                    arrayType = (Field)additionalField.eContainer();
                    size += (long)additionalField.getArrayDimensionsAfter().size();
                    size -= (long)arrayType.getArrayDimensionsAfter().size();
                }
            } else if (expression instanceof ArrayTypeable) {
                size += (long)(((ArrayTypeable)((Object)expression)).getArrayDimensionsBefore().size() + ((ArrayTypeable)((Object)expression)).getArrayDimensionsAfter().size());
                if (expression instanceof VariableLengthParameter) {
                    ++size;
                }
            }
            size -= (long)reference.getArraySelectors().size();
        } else if (expression instanceof ArrayTypeable) {
            size += (long)(((ArrayTypeable)((Object)expression)).getArrayDimensionsBefore().size() + ((ArrayTypeable)((Object)expression)).getArrayDimensionsAfter().size());
            if (expression instanceof VariableLengthParameter) {
                ++size;
            }
        }
        if (expression instanceof ArrayInstantiationBySize) {
            size += (long)((ArrayInstantiationBySize)expression).getSizes().size();
        }
        if (arrayType != null) {
            size += arrayType.getArrayDimension();
        }
        return size;
    }
}

