/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.generics;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.CastExpression;
import tools.mdsd.jamopp.model.java.expressions.ConditionalExpression;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.expressions.NestedExpression;
import tools.mdsd.jamopp.model.java.generics.ExtendsTypeArgument;
import tools.mdsd.jamopp.model.java.generics.QualifiedTypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.generics.TypeParametrizable;
import tools.mdsd.jamopp.model.java.instantiations.NewConstructorCall;
import tools.mdsd.jamopp.model.java.literals.Super;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.references.ElementReference;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.references.ReflectiveClassReference;
import tools.mdsd.jamopp.model.java.references.SelfReference;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.PrimitiveType;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypedElement;
import tools.mdsd.jamopp.model.java.util.TemporalCompositeClassifier;
import tools.mdsd.jamopp.model.java.util.TemporalTypeArgumentHolder;

public final class TypeParameterExtension {
    private TypeParameterExtension() {
    }

    public static EList<ConcreteClassifier> getAllSuperClassifiers(TypeParameter typeParameter) {
        UniqueEList result = new UniqueEList();
        for (TypeReference typeRef : typeParameter.getExtendTypes()) {
            Type type = typeRef.getTarget();
            if (type instanceof ConcreteClassifier var5_5) {
                result.add((Object)concreteClassifier);
            }
            if (!(( instanceOfPatternExpressionValue = type) instanceof Classifier) || (var7_7 = (Classifier) instanceOfPatternExpressionValue) != (Classifier) instanceOfPatternExpressionValue) continue;
            result.addAll(classifier.getAllSuperClassifiers());
        }
        return result;
    }

    public static EList<Member> getAllMembers(TypeParameter typeParameter, Commentable context) {
        UniqueEList memberList = new UniqueEList();
        UniqueEList possiblyVisibleSuperClassifier = new UniqueEList();
        for (TypeReference typeReference : typeParameter.getExtendTypes()) {
            Type target = typeReference.getTarget();
            possiblyVisibleSuperClassifier.add((Object)target);
        }
        for (ConcreteClassifier superClassifier : typeParameter.getAllSuperClassifiers()) {
            for (Member member : superClassifier.getMembers()) {
                if (member instanceof AnnotableAndModifiable var8_8) {
                    if (modifiable.isHidden(context) && !possiblyVisibleSuperClassifier.contains((Object)superClassifier)) continue;
                    memberList.add((Object)member);
                    continue;
                }
                memberList.add((Object)member);
            }
            memberList.addAll((Collection)superClassifier.getDefaultMembers());
        }
        return memberList;
    }

    /*
     * WARNING - void declaration
     */
    public static Type getBoundType(TypeParameter typeParameter, EObject typeReference, Reference reference) {
        Commentable prevType;
        BasicEList resultList = new BasicEList();
        TypeParametrizable typeParameterDeclarator = (TypeParametrizable)typeParameter.eContainer();
        Reference parentReference = null;
        UniqueEList prevTypeList = new UniqueEList();
        if (reference != null && reference.getPrevious() instanceof NestedExpression) {
            parentReference = TypeParameterExtension.getParentReferenceAndFillPrevTypeListWithNested(reference, (EList<Type>)prevTypeList);
        } else if (reference != null && reference.getPrevious() != null) {
            parentReference = TypeParameterExtension.getParentReferenceAndFillPrevTypeList(reference, (EList<Type>)prevTypeList);
        } else if (reference != null) {
            TypeParameterExtension.fillPrevTypeList(reference, (EList<Type>)prevTypeList);
        }
        Object object = prevTypeList.iterator();
        while (object.hasNext()) {
            prevType = (Type)object.next();
            TypeParameterExtension.processType(typeParameter, reference, (EList<Type>)resultList, typeParameterDeclarator, parentReference, prevType);
        }
        TypeParametrizable typeParametrizable = typeParameterDeclarator;
        if (typeParametrizable instanceof Method && (prevType = (Method)typeParametrizable) == (Method)typeParametrizable && ( instanceOfPatternExpressionValue = reference) instanceof MethodCall && (object = (MethodCall) instanceOfPatternExpressionValue) == (MethodCall) instanceOfPatternExpressionValue) {
            void methodCall;
            void method;
            TypeParameterExtension.handleTypeAndReferenceAreMethods(typeParameter, typeReference, (EList<Type>)resultList, parentReference, (Method)method, (MethodCall)methodCall);
        }
        TypeParameterExtension.removeNulls((EList<Type>)resultList);
        if (resultList.isEmpty() || resultList.size() == 1 && ((Type)resultList.get(0)).equals(typeParameter)) {
            return typeParameter;
        }
        TemporalCompositeClassifier temp = new TemporalCompositeClassifier(typeParameter);
        for (Type aResult : resultList) {
            TypeParameterExtension.processResult(temp, aResult);
        }
        temp.getSuperTypes().add((Object)typeParameter);
        return temp;
    }

    private static void removeNulls(EList<Type> resultList) {
        Iterator it = resultList.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
    }

    private static Type processResult(TemporalCompositeClassifier temp, Type aResult) {
        Type newResult = aResult;
        if (newResult instanceof PrimitiveType) {
            newResult = ((PrimitiveType)newResult).wrapPrimitiveType();
        }
        if (newResult instanceof TemporalCompositeClassifier) {
            temp.getSuperTypes().addAll(((TemporalCompositeClassifier)newResult).getSuperTypes());
        } else {
            temp.getSuperTypes().add((Object)newResult);
        }
        return newResult;
    }

    private static void handleTypeAndReferenceAreMethods(TypeParameter typeParameter, EObject typeReference, EList<Type> resultList, Reference parentReference, Method method, MethodCall methodCall) {
        int idx;
        TypeArgument typeArgument;
        if (method.getTypeParameters().size() == methodCall.getCallTypeArguments().size() && (typeArgument = (TypeArgument)methodCall.getCallTypeArguments().get(method.getTypeParameters().indexOf((Object)typeParameter))) instanceof QualifiedTypeArgument) {
            resultList.add(0, (Object)((QualifiedTypeArgument)typeArgument).getTypeReference().getBoundTarget(parentReference));
        }
        if ((idx = method.getParameters().indexOf((Object)typeReference.eContainer())) == -1) {
            idx = TypeParameterExtension.handleIndexIsMinusOne(typeParameter, method, idx);
        }
        if (idx < methodCall.getArguments().size() && idx >= 0) {
            TypeParameterExtension.handleIndexInBetween(typeParameter, resultList, method, methodCall, idx);
        }
        if (method.equals(typeReference.eContainer())) {
            EList<Classifier> allSuperTypes = null;
            for (Parameter parameter : method.getParameters()) {
                allSuperTypes = TypeParameterExtension.handleMethodParameter(typeParameter, method, methodCall, allSuperTypes, parameter);
            }
            if (allSuperTypes != null) {
                resultList.addAll(allSuperTypes);
            }
        }
    }

    private static EList<Classifier> handleMethodParameter(TypeParameter typeParameter, Method method, MethodCall methodCall, EList<Classifier> allSuperTypes, Parameter parameter) {
        UniqueEList newAllSuperTypes = allSuperTypes;
        if (typeParameter.equals(parameter.getTypeReference().getTarget())) {
            int idx = method.getParameters().indexOf((Object)parameter);
            Classifier argumentType = (Classifier)((Expression)methodCall.getArguments().get(idx)).getType();
            if (newAllSuperTypes == null) {
                newAllSuperTypes = new UniqueEList();
                newAllSuperTypes.add((Object)argumentType);
                newAllSuperTypes.addAll(argumentType.getAllSuperClassifiers());
            } else {
                newAllSuperTypes.add((Object)argumentType);
                UniqueEList allOtherSuperTypes = new UniqueEList();
                allOtherSuperTypes.add((Object)argumentType);
                allOtherSuperTypes.addAll(argumentType.getAllSuperClassifiers());
                UniqueEList temp = newAllSuperTypes;
                newAllSuperTypes = new UniqueEList();
                for (Classifier st : allOtherSuperTypes) {
                    if (!temp.contains((Object)st)) continue;
                    newAllSuperTypes.add((Object)st);
                }
            }
        }
        return newAllSuperTypes;
    }

    private static void handleIndexInBetween(TypeParameter typeParameter, EList<Type> resultList, Method method, MethodCall methodCall, int idx) {
        Expression argument = (Expression)methodCall.getArguments().get(idx);
        Parameter parameter = (Parameter)method.getParameters().get(idx);
        ClassifierReference parameterType = parameter.getTypeReference().getPureClassifierReference();
        if (argument instanceof NewConstructorCall) {
            ClassifierReference argumentType = ((NewConstructorCall)argument).getTypeReference().getPureClassifierReference();
            if (argumentType != null && parameterType.getTypeArguments().size() == argumentType.getTypeArguments().size()) {
                for (TypeArgument typeArgument : parameterType.getTypeArguments()) {
                    if (!(typeArgument instanceof QualifiedTypeArgument) || !((QualifiedTypeArgument)typeArgument).getTypeReference().getTarget().equals(typeParameter)) continue;
                    resultList.add(0, (Object)((QualifiedTypeArgument)argumentType.getTypeArguments().get(parameterType.getTypeArguments().indexOf((Object)typeArgument))).getTypeReference().getTarget());
                }
            }
            if (argumentType != null && parameterType.getTarget() instanceof TypeParameter) {
                resultList.add(0, (Object)argumentType.getTarget());
            }
        } else if (parameterType != null && argument instanceof Reference argumentType) {
            while (!(argReference.getNext() instanceof ReflectiveClassReference)) {
                argReference = argReference.getNext();
            }
            if (argReference instanceof ElementReference var10_11) {
                while (elementReference.getNext() instanceof ElementReference) {
                    elementReference = (ElementReference)elementReference.getNext();
                }
                if (elementReference.getTarget() instanceof TypedElement && (typeRef = ((TypedElement)((Object)elementReference.getTarget())).getTypeReference()) != null) {
                    ClassifierReference argumentType = typeRef.getPureClassifierReference();
                    if (argumentType != null && parameterType.getTypeArguments().size() == argumentType.getTypeArguments().size()) {
                        for (TypeArgument typeArgument : parameterType.getTypeArguments()) {
                            if (!(typeArgument instanceof QualifiedTypeArgument) || !((QualifiedTypeArgument)typeArgument).getTypeReference().getTarget().equals(typeParameter)) continue;
                            int idx2 = parameterType.getTypeArguments().indexOf((Object)typeArgument);
                            if (argumentType.getTypeArguments().get(idx2) instanceof QualifiedTypeArgument) {
                                resultList.add(0, (Object)((QualifiedTypeArgument)argumentType.getTypeArguments().get(idx2)).getTypeReference().getTarget());
                                continue;
                            }
                            if (!(argumentType.getTypeArguments().get(idx2) instanceof ExtendsTypeArgument)) continue;
                            resultList.add(0, (Object)((ExtendsTypeArgument)argumentType.getTypeArguments().get(idx2)).getExtendType().getTarget());
                        }
                    }
                    if (argumentType != null && parameterType.getTarget() instanceof TypeParameter) {
                        resultList.add(0, (Object)argumentType.getTarget());
                    }
                }
                if (elementReference.getNext() instanceof ReflectiveClassReference && parameterType.getTypeArguments().size() == 1) {
                    for (TypeArgument typeArgument : parameterType.getTypeArguments()) {
                        if (!(typeArgument instanceof QualifiedTypeArgument) || !((QualifiedTypeArgument)typeArgument).getTypeReference().getTarget().equals(typeParameter)) continue;
                        resultList.add(0, (Object)elementReference.getReferencedType());
                    }
                }
            } else if (parameterType.getTarget() instanceof TypeParameter) {
                while (argReference.getNext() != null) {
                    argReference = argReference.getNext();
                }
                resultList.add(0, (Object)argReference.getReferencedType());
            }
        }
    }

    private static int handleIndexIsMinusOne(TypeParameter typeParameter, Method method, int idx) {
        int newIdx = idx;
        for (Parameter parameter : method.getParameters()) {
            for (TypeArgument typeArgument : parameter.getTypeArguments()) {
                if (!(typeArgument instanceof QualifiedTypeArgument) || !((QualifiedTypeArgument)typeArgument).getTypeReference().getTarget().equals(typeParameter)) continue;
                newIdx = method.getParameters().indexOf((Object)parameter);
            }
            ClassifierReference paramTypeReference = parameter.getTypeReference().getPureClassifierReference();
            if (paramTypeReference == null) continue;
            for (TypeArgument typeArgument : paramTypeReference.getTypeArguments()) {
                if (!(typeArgument instanceof QualifiedTypeArgument) || !typeParameter.equals(((QualifiedTypeArgument)typeArgument).getTypeReference().getTarget())) continue;
                newIdx = method.getParameters().indexOf((Object)parameter);
            }
        }
        return newIdx;
    }

    private static void processType(TypeParameter typeParameter, Reference reference, EList<Type> resultList, TypeParametrizable typeParameterDeclarator, Reference parentReference, Type prevType) {
        if (typeParameterDeclarator instanceof ConcreteClassifier) {
            int typeParameterIndex = typeParameterDeclarator.getTypeParameters().indexOf((Object)typeParameter);
            if (reference != null) {
                TypeReference prevParentReference;
                TypeReference prevTypeReference;
                ReferenceableElement prevReferenced;
                ClassifierReference classifierReference = null;
                if (parentReference instanceof ElementReference && (prevReferenced = ((ElementReference)parentReference).getTarget()) instanceof TypedElement && (prevTypeReference = ((TypedElement)((Object)prevReferenced)).getTypeReference()) != null) {
                    classifierReference = prevTypeReference.getPureClassifierReference();
                }
                if (parentReference instanceof TypedElement && (prevParentReference = ((TypedElement)((Object)parentReference)).getTypeReference()) != null) {
                    classifierReference = prevParentReference.getPureClassifierReference();
                }
                if (prevType instanceof ConcreteClassifier) {
                    TypeParameterExtension.handleConcreteClassifier(resultList, typeParameterDeclarator, parentReference, prevType, typeParameterIndex, classifierReference);
                } else if (prevType instanceof TypeParameter) {
                    TypeParameterExtension.handleTypeParameter(resultList, prevType);
                }
            }
            if (reference != null && reference.eContainer() instanceof ReflectiveClassReference && reference.eContainer().eContainer() instanceof Reference) {
                resultList.add(0, (Object)((Reference)reference.eContainer().eContainer()).getReferencedType());
            }
        }
    }

    private static void handleTypeParameter(EList<Type> resultList, Type prevType) {
        resultList.add((Object)prevType);
        for (TypeReference extendedRef : ((TypeParameter)prevType).getExtendTypes()) {
            ConcreteClassifier extended = (ConcreteClassifier)extendedRef.getTarget();
            int idx = ((TypeParametrizable)prevType.eContainer()).getTypeParameters().indexOf((Object)prevType);
            if (extended.getTypeParameters().size() <= idx) continue;
            resultList.add((Object)((Type)extended.getTypeParameters().get(idx)));
        }
    }

    private static void handleConcreteClassifier(EList<Type> resultList, TypeParametrizable typeParameterDeclarator, Reference parentReference, Type prevType, int typeParameterIndex, ClassifierReference classifierReference) {
        TypeArgument arg;
        int idx = 0;
        for (ClassifierReference superClassifierReference : ((ConcreteClassifier)prevType).getSuperTypeReferences()) {
            if (typeParameterIndex >= superClassifierReference.getTypeArguments().size() || !typeParameterDeclarator.equals(superClassifierReference.getTarget()) && !superClassifierReference.getTarget().getAllSuperClassifiers().contains((Object)typeParameterDeclarator) || !((arg = (TypeArgument)superClassifierReference.getTypeArguments().get(typeParameterIndex)) instanceof QualifiedTypeArgument)) continue;
            resultList.add(idx, (Object)((QualifiedTypeArgument)arg).getTypeReference().getTarget());
            ++idx;
        }
        TemporalTypeArgumentHolder ttah = null;
        for (Adapter adapter : prevType.eAdapters()) {
            if (!(adapter instanceof TemporalTypeArgumentHolder)) continue;
            ttah = (TemporalTypeArgumentHolder)adapter;
            prevType.eAdapters().remove((Object)ttah);
            break;
        }
        EList typeArgumentList = ttah != null ? ttah.getTypeArguments() : (classifierReference != null ? classifierReference.getTypeArguments() : ECollections.emptyEList());
        if (typeParameterIndex < typeArgumentList.size()) {
            Type theType;
            ClassifierReference theTypeRef;
            arg = (TypeArgument)typeArgumentList.get(typeParameterIndex);
            if (arg instanceof QualifiedTypeArgument && (theTypeRef = ((QualifiedTypeArgument)arg).getTypeReference().getPureClassifierReference()) != null && (theType = theTypeRef.getBoundTarget(parentReference)) != null) {
                if (!theTypeRef.getTypeArguments().isEmpty()) {
                    ttah = new TemporalTypeArgumentHolder();
                    ttah.getTypeArguments().addAll((Collection)theTypeRef.getTypeArguments());
                    theType.eAdapters().add((Object)ttah);
                }
                resultList.add(0, (Object)theType);
            }
            if (arg instanceof ExtendsTypeArgument) {
                resultList.add(0, (Object)((ExtendsTypeArgument)arg).getExtendType().getBoundTarget(parentReference));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void fillPrevTypeList(Reference reference, EList<Type> prevTypeList) {
        Optional<ConcreteClassifier> containingClassifier = Optional.of(reference.getContainingConcreteClassifier());
        while (containingClassifier.isPresent()) {
            void commentableContainer;
            Commentable commentable;
            EObject container;
            prevTypeList.add((Object)containingClassifier.get());
            EObject eObject = container = containingClassifier.get().eContainer();
            containingClassifier = eObject instanceof Commentable && (commentable = (Commentable)eObject) == (Commentable)eObject ? Optional.of(commentableContainer.getContainingConcreteClassifier()) : Optional.empty();
        }
    }

    private static Reference getParentReferenceAndFillPrevTypeList(Reference reference, EList<Type> prevTypeList) {
        Optional<Reference> parentReference = Optional.of(reference.getPrevious());
        while (parentReference.get() instanceof SelfReference) {
            if (!(((SelfReference)parentReference.get()).getSelf() instanceof Super)) break;
            if (parentReference.get().eContainer() instanceof Reference) {
                parentReference = Optional.of((Reference)parentReference.get().eContainer());
                continue;
            }
            ConcreteClassifier containingClassifier = reference.getContainingConcreteClassifier();
            if (containingClassifier != null) {
                prevTypeList.add((Object)containingClassifier);
            }
            parentReference = Optional.empty();
        }
        if (parentReference.isPresent()) {
            Type prevType = parentReference.get().getReferencedType();
            if (prevType instanceof TemporalCompositeClassifier var4_5) {
                for (EObject aType : temporalCompositeClassifier.getSuperTypes()) {
                    prevTypeList.add((Object)((Type)aType));
                }
            } else {
                prevTypeList.add((Object)prevType);
            }
        }
        return parentReference.get();
    }

    private static Reference getParentReferenceAndFillPrevTypeListWithNested(Reference reference, EList<Type> prevTypeList) {
        Reference newParentReference = null;
        NestedExpression nestedExpression = (NestedExpression)reference.getPrevious();
        Expression expression = null;
        Expression nestedExpressionExpression = nestedExpression.getExpression();
        if (nestedExpressionExpression instanceof Reference) {
            expression = nestedExpressionExpression;
        } else {
            if (nestedExpressionExpression instanceof ConditionalExpression var6_7) {
                expression = conditionalExpression.getExpressionIf();
            }
        }
        if (expression instanceof Reference var8_9) {
            while (expressionReference.getNext() != null) {
                expressionReference = expressionReference.getNext();
            }
            newParentReference = expressionReference;
            Type prevType = nestedExpressionExpression.getType();
            if (prevType instanceof TemporalCompositeClassifier var11_13) {
                for (EObject nextSuperType : temporalCompositeClassifier.getSuperTypes()) {
                    prevTypeList.add((Object)((Type)nextSuperType));
                }
            } else {
                prevTypeList.add((Object)prevType);
            }
        } else {
            if (nestedExpressionExpression instanceof CastExpression prevType) {
                prevTypeList.add((Object)castExpression.getTypeReference().getTarget());
            }
        }
        return newParentReference;
    }
}

