/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.members;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.instantiations.NewConstructorCall;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;

public final class ConstructorExtension {
    private ConstructorExtension() {
    }

    public static boolean isBetterConstructorForCall(Constructor constructor, Constructor other, NewConstructorCall call) {
        boolean result = ConstructorExtension.isConstructorForCall(other, call, true) ? false : (ConstructorExtension.isConstructorForCall(other, call, false) ? ConstructorExtension.isConstructorForCall(constructor, call, true) : ConstructorExtension.isConstructorForCall(constructor, call, false));
        return result;
    }

    public static boolean isConstructorForCall(Constructor constructor, NewConstructorCall call, boolean needsPerfectMatch) {
        Type callType = call.getReferencedType();
        if (!(callType instanceof ConcreteClassifier) || !((ConcreteClassifier)callType).getMembers().contains((Object)constructor)) {
            return false;
        }
        EList argumentTypeList = call.getArgumentTypes();
        BasicEList parameterList = new BasicEList((Collection)constructor.getParameters());
        BasicEList parameterTypeList = new BasicEList();
        for (Parameter parameter : parameterList) {
            TypeReference typeReference = parameter.getTypeReference();
            Type boundTarget = typeReference.getBoundTarget(call);
            parameterTypeList.add((Object)boundTarget);
        }
        if (!parameterList.isEmpty()) {
            Parameter lastParameter = (Parameter)parameterList.get(parameterList.size() - 1);
            Type lastParameterType = (Type)parameterTypeList.get(parameterTypeList.size() - 1);
            if (lastParameter instanceof VariableLengthParameter) {
                while (parameterList.size() < argumentTypeList.size()) {
                    if (needsPerfectMatch) {
                        return false;
                    }
                    parameterList.add((Object)lastParameter);
                    parameterTypeList.add((Object)lastParameterType);
                }
                if (parameterList.size() > argumentTypeList.size()) {
                    if (needsPerfectMatch) {
                        return false;
                    }
                    parameterList.remove((Object)lastParameter);
                    parameterTypeList.remove(parameterTypeList.size() - 1);
                }
            }
        }
        if (parameterList.size() == argumentTypeList.size()) {
            boolean parametersMatch = true;
            int i = 0;
            while (i < argumentTypeList.size()) {
                Type parameterType = (Type)parameterTypeList.get(i);
                Type argumentType = (Type)argumentTypeList.get(i);
                if (argumentType == null || parameterType == null || parameterType.eIsProxy() && argumentType.eIsProxy()) {
                    return false;
                }
                Expression argument = (Expression)call.getArguments().get(i);
                long argumentArrayDimension = argument.getArrayDimension();
                Parameter parameter = (Parameter)parameterList.get(i);
                if (needsPerfectMatch) {
                    long parameterArrayDimension = parameter.getArrayDimension();
                    parametersMatch = parametersMatch && argumentType.equalsType(argumentArrayDimension, parameterType, parameterArrayDimension);
                } else {
                    parametersMatch = parametersMatch && argumentType.isSuperType(argumentArrayDimension, parameterType, parameter);
                }
                ++i;
            }
            return parametersMatch;
        }
        return false;
    }
}

