/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.members;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;

public final class MethodExtension {
    private MethodExtension() {
    }

    public static boolean isSomeMethodForCall(Method method, MethodCall methodCall) {
        return method.isMethodForCall(methodCall, false);
    }

    public static boolean isBetterMethodForCall(Method method, Method otherMethod, MethodCall methodCall) {
        Type target;
        boolean result = method.isMethodForCall(methodCall, false) ? (otherMethod.isMethodForCall(methodCall, true) && method.isMethodForCall(methodCall, true) ? (target = method.getTypeReference().getTarget()) instanceof ConcreteClassifier && ((ConcreteClassifier)target).getAllSuperClassifiers().contains((Object)otherMethod.getTypeReference().getTarget()) : false) : (otherMethod.isMethodForCall(methodCall, false) ? method.isMethodForCall(methodCall, true) : true);
        return result;
    }

    public static boolean isMethodForCall(Method method, MethodCall methodCall, boolean needsPerfectMatch) {
        EList argumentTypeList = methodCall.getArgumentTypes();
        BasicEList parameterList = new BasicEList((Collection)method.getParameters());
        BasicEList parameterTypeList = new BasicEList();
        for (Parameter parameter : parameterList) {
            TypeReference typeReference = parameter.getTypeReference();
            Type boundTarget = typeReference.getBoundTarget(methodCall);
            parameterTypeList.add((Object)boundTarget);
        }
        if (!parameterList.isEmpty()) {
            Parameter lastParameter = (Parameter)parameterList.get(parameterList.size() - 1);
            Type lastParameterType = (Type)parameterTypeList.get(parameterTypeList.size() - 1);
            if (lastParameter instanceof VariableLengthParameter) {
                while (parameterList.size() < argumentTypeList.size()) {
                    if (needsPerfectMatch) {
                        return false;
                    }
                    parameterList.add((Object)lastParameter);
                    parameterTypeList.add((Object)lastParameterType);
                }
                if (parameterList.size() > argumentTypeList.size()) {
                    if (needsPerfectMatch) {
                        return false;
                    }
                    parameterList.remove((Object)lastParameter);
                    parameterTypeList.remove(parameterTypeList.size() - 1);
                }
            }
        }
        if (parameterList.size() == argumentTypeList.size()) {
            boolean parametersMatch = true;
            int i = 0;
            while (i < argumentTypeList.size()) {
                Type parameterType = (Type)parameterTypeList.get(i);
                Type argumentType = (Type)argumentTypeList.get(i);
                if (argumentType == null || parameterType == null || parameterType.eIsProxy() && argumentType.eIsProxy()) {
                    return false;
                }
                Expression argument = (Expression)methodCall.getArguments().get(i);
                long argumentArrayDimension = argument.getArrayDimension();
                Parameter parameter = (Parameter)parameterList.get(i);
                if (needsPerfectMatch) {
                    long parameterArrayDimension = parameter.getArrayDimension();
                    parametersMatch = parametersMatch && argumentType.equalsType(argumentArrayDimension, parameterType, parameterArrayDimension);
                } else {
                    parametersMatch = parametersMatch && argumentType.isSuperType(argumentArrayDimension, parameterType, parameter);
                }
                ++i;
            }
            return parametersMatch;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static Block getBlock(Method method) {
        void var3_2;
        Block block;
        Block result = null;
        Statement statement = method.getStatement();
        if (statement instanceof Block && (block = (Block)statement) == (Block)var3_2) {
            void block2;
            result = block2;
        }
        return result;
    }
}

