/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.modifiers;

import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.modifiers.AnnotableAndModifiable;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.modifiers.Modifier;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersFactory;
import tools.mdsd.jamopp.model.java.modifiers.Private;
import tools.mdsd.jamopp.model.java.modifiers.Protected;
import tools.mdsd.jamopp.model.java.modifiers.Public;
import tools.mdsd.jamopp.model.java.modifiers.Static;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.SelfReference;
import tools.mdsd.jamopp.model.java.types.Type;

public final class AnnotableAndModifiableExtension {
    private AnnotableAndModifiableExtension() {
    }

    public static void makePrivate(AnnotableAndModifiable annotableAndModifiable) {
        if (annotableAndModifiable.isPrivate()) {
            return;
        }
        annotableAndModifiable.removeModifier(Public.class);
        annotableAndModifiable.removeModifier(Protected.class);
        annotableAndModifiable.getAnnotationsAndModifiers().add((Object)ModifiersFactory.eINSTANCE.createPrivate());
    }

    public static void makePublic(AnnotableAndModifiable annotableAndModifiable) {
        if (annotableAndModifiable.isPublic()) {
            return;
        }
        annotableAndModifiable.removeModifier(Private.class);
        annotableAndModifiable.removeModifier(Protected.class);
        annotableAndModifiable.getAnnotationsAndModifiers().add((Object)ModifiersFactory.eINSTANCE.createPublic());
    }

    public static void makeProtected(AnnotableAndModifiable annotableAndModifiable) {
        if (annotableAndModifiable.isProtected()) {
            return;
        }
        annotableAndModifiable.removeModifier(Private.class);
        annotableAndModifiable.removeModifier(Public.class);
        annotableAndModifiable.getAnnotationsAndModifiers().add((Object)ModifiersFactory.eINSTANCE.createProtected());
    }

    public static void removeAllModifiers(AnnotableAndModifiable annotableAndModifiable) {
        EList<Modifier> modifiers = annotableAndModifiable.getModifiers();
        EList<AnnotationInstanceOrModifier> elements = annotableAndModifiable.getAnnotationsAndModifiers();
        elements.removeAll(modifiers);
    }

    public static EList<Modifier> getModifiers(AnnotableAndModifiable annotableAndModifiable) {
        EList<AnnotationInstanceOrModifier> elements = annotableAndModifiable.getAnnotationsAndModifiers();
        BasicEList modifiers = new BasicEList();
        for (AnnotationInstanceOrModifier next : elements) {
            if (!(next instanceof Modifier)) continue;
            modifiers.add((Object)((Modifier)next));
        }
        return ECollections.unmodifiableEList((EList)modifiers);
    }

    public static EList<AnnotationInstance> getAnnotationInstances(AnnotableAndModifiable annotableAndModifiable) {
        EList<AnnotationInstanceOrModifier> elements = annotableAndModifiable.getAnnotationsAndModifiers();
        BasicEList annotations = new BasicEList();
        for (AnnotationInstanceOrModifier next : elements) {
            if (!(next instanceof AnnotationInstance)) continue;
            annotations.add((Object)((AnnotationInstance)next));
        }
        return ECollections.unmodifiableEList((EList)annotations);
    }

    public static void addModifier(AnnotableAndModifiable annotableAndModifiable, Modifier newModifier) {
        annotableAndModifiable.getAnnotationsAndModifiers().add((Object)newModifier);
    }

    public static void removeModifier(AnnotableAndModifiable annotableAndModifiable, Class<?> modifierType) {
        EList<AnnotationInstanceOrModifier> modifiers = annotableAndModifiable.getAnnotationsAndModifiers();
        ArrayList<AnnotationInstanceOrModifier> modifiersToRemove = new ArrayList<AnnotationInstanceOrModifier>();
        for (AnnotationInstanceOrModifier modifier : modifiers) {
            if (!modifierType.isInstance(modifier)) continue;
            modifiersToRemove.add(modifier);
        }
        modifiers.removeAll(modifiersToRemove);
    }

    public static boolean isPublic(AnnotableAndModifiable annotableAndModifiable) {
        return annotableAndModifiable.hasModifier(Public.class);
    }

    public static boolean isPrivate(AnnotableAndModifiable annotableAndModifiable) {
        return annotableAndModifiable.hasModifier(Private.class);
    }

    public static boolean isProtected(AnnotableAndModifiable annotableAndModifiable) {
        return annotableAndModifiable.hasModifier(Protected.class);
    }

    public static boolean hasModifier(AnnotableAndModifiable annotableAndModifiable, Class<?> type) {
        boolean result = false;
        EList<AnnotationInstanceOrModifier> modifiers = annotableAndModifiable.getAnnotationsAndModifiers();
        for (AnnotationInstanceOrModifier modifier : modifiers) {
            if (!type.isInstance(modifier)) continue;
            result = true;
        }
        return result;
    }

    public static boolean isStatic(AnnotableAndModifiable annotableAndModifiable) {
        boolean result = false;
        if (annotableAndModifiable.eContainer() instanceof Interface) {
            result = true;
        }
        for (AnnotationInstanceOrModifier modifier : annotableAndModifiable.getAnnotationsAndModifiers()) {
            if (!(modifier instanceof Static)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isHidden(AnnotableAndModifiable annotableAndModifiable, Commentable context) {
        Type type;
        SelfReference selfReference;
        Commentable lContext = context;
        if (annotableAndModifiable.eIsProxy() || annotableAndModifiable.eContainer() instanceof Interface) {
            return false;
        }
        if (lContext.eIsProxy()) {
            lContext = (Commentable)EcoreUtil.resolve((EObject)lContext, (EObject)annotableAndModifiable);
        } else if (!(annotableAndModifiable.eContainer() instanceof Commentable)) {
            return true;
        }
        ConcreteClassifier iContextClassifier = lContext.getContainingConcreteClassifier();
        ConcreteClassifier myClassifier = ((Commentable)annotableAndModifiable.eContainer()).getParentConcreteClassifier();
        if (lContext instanceof Reference && ((Reference)lContext).getPrevious() instanceof SelfReference && (selfReference = (SelfReference)((Reference)lContext).getPrevious()).getPrevious() != null && (type = selfReference.getPrevious().getReferencedType()) instanceof ConcreteClassifier) {
            iContextClassifier = (ConcreteClassifier)type;
        }
        for (AnnotationInstanceOrModifier modifier : annotableAndModifiable.getAnnotationsAndModifiers()) {
            if (modifier instanceof Private) {
                return myClassifier.equalsType(0L, iContextClassifier, 0L);
            }
            if (modifier instanceof Public) {
                return false;
            }
            if (!(modifier instanceof Protected)) continue;
            return AnnotableAndModifiableExtension.checkProtected(myClassifier, myClassifier, lContext, lContext);
        }
        return annotableAndModifiable.getContainingPackageName() == null || !annotableAndModifiable.getContainingPackageName().equals(lContext.getContainingPackageName());
    }

    private static boolean checkProtected(ConcreteClassifier iContextClassifier, ConcreteClassifier myClassifier, Commentable commentable, Commentable lContext) {
        if (commentable.getContainingPackageName() != null && commentable.getContainingPackageName().equals(lContext.getContainingPackageName())) {
            return false;
        }
        Optional<ConcreteClassifier> concreteClassifier = Optional.of(iContextClassifier);
        while (concreteClassifier.isPresent()) {
            if (concreteClassifier.get().isSuperType(0L, myClassifier, null)) {
                return false;
            }
            if (!(concreteClassifier = concreteClassifier.get().eContainer() instanceof Commentable ? Optional.of(((Commentable)concreteClassifier.get().eContainer()).getParentConcreteClassifier()) : Optional.empty()).isPresent() || concreteClassifier.get().eIsProxy() || !concreteClassifier.get().isSuperType(0L, myClassifier, null)) continue;
            return false;
        }
        Optional<AnonymousClass> anonymousClass = Optional.of(lContext.getContainingAnonymousClass());
        while (anonymousClass.isPresent()) {
            if (anonymousClass.get().getSuperClassifier() == null) {
                return true;
            }
            if (anonymousClass.get().getSuperClassifier().isSuperType(0L, myClassifier, null)) {
                return false;
            }
            anonymousClass = anonymousClass.get().eContainer() instanceof Commentable ? Optional.of(((Commentable)anonymousClass.get().eContainer()).getContainingAnonymousClass()) : Optional.empty();
        }
        return true;
    }
}

