/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.model.java.extensions.references;

import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.expressions.NestedExpression;
import tools.mdsd.jamopp.model.java.literals.Literal;
import tools.mdsd.jamopp.model.java.literals.Super;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.references.ElementReference;
import tools.mdsd.jamopp.model.java.references.PrimitiveTypeReference;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.references.ReflectiveClassReference;
import tools.mdsd.jamopp.model.java.references.SelfReference;
import tools.mdsd.jamopp.model.java.references.StringReference;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypedElement;

public final class ReferenceExtension {
    private ReferenceExtension() {
    }

    public static Reference getPrevious(Reference reference) {
        Reference result = null;
        if (reference.eContainer() instanceof Reference && reference.equals(((Reference)reference.eContainer()).getNext())) {
            result = (Reference)reference.eContainer();
        }
        return result;
    }

    public static Type getReferencedType(Reference reference) {
        Type type = null;
        if (reference instanceof Literal) {
            type = ReferenceExtension.handeLiteral(reference);
        } else if (reference instanceof TypedElement) {
            type = ReferenceExtension.handleTypedElement(reference);
        } else if (reference instanceof SelfReference) {
            type = ReferenceExtension.handleSelfReference(reference);
        } else if (reference instanceof ReflectiveClassReference) {
            type = ReferenceExtension.handleReflectiveClassReference(reference);
        } else if (reference instanceof ElementReference) {
            type = ReferenceExtension.handleElementReference(reference);
        } else if (reference instanceof StringReference) {
            type = ReferenceExtension.handleStringReference(reference);
        } else if (reference instanceof NestedExpression) {
            type = ReferenceExtension.handleNestedExpression(reference);
        } else if (reference instanceof PrimitiveTypeReference) {
            type = ReferenceExtension.handlePrimitiveTypeReference(reference);
        } else assert (false);
        return type;
    }

    private static Type handleElementReference(Reference reference) {
        ReferenceableElement target = ((ElementReference)reference).getTarget();
        Type newType = null;
        if (target instanceof TypedElement) {
            TypeReference typeRef = ((TypedElement)((Object)target)).getTypeReference();
            if (typeRef != null) {
                newType = typeRef.getBoundTarget(reference);
            }
        } else if (target instanceof Type) {
            newType = (Type)((Object)target);
        } else if (target instanceof EnumConstant) {
            newType = (Enumeration)target.eContainer();
        }
        return newType;
    }

    private static Type handlePrimitiveTypeReference(Reference reference) {
        return ((PrimitiveTypeReference)reference).getPrimitiveType();
    }

    private static Type handleNestedExpression(Reference reference) {
        return ((NestedExpression)reference).getExpression().getType();
    }

    private static Type handleStringReference(Reference reference) {
        return reference.getStringClass();
    }

    private static Type handleReflectiveClassReference(Reference reference) {
        return reference.getClassClass();
    }

    private static Type handleSelfReference(Reference reference) {
        AnonymousClass anonymousContainer;
        Type thisClass = reference.getPrevious() != null ? reference.getPrevious().getReferencedType() : ((anonymousContainer = reference.getContainingAnonymousClass()) != null ? anonymousContainer : reference.getContainingConcreteClassifier());
        Type result = ((SelfReference)reference).getSelf() instanceof Super ? (thisClass instanceof Class ? ((Class)thisClass).getSuperClass() : (thisClass instanceof AnonymousClass ? ((AnonymousClass)thisClass).getSuperClassifier() : thisClass)) : thisClass;
        return result;
    }

    private static Type handleTypedElement(Reference reference) {
        TypeReference typeRef = ((TypedElement)((Object)reference)).getTypeReference();
        return typeRef.getBoundTarget(reference);
    }

    private static Type handeLiteral(Reference reference) {
        return ((Literal)((Object)reference)).getType();
    }
}

